/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.util;

import cn.fyupeng.enums.LoadBalancerCode;
import cn.fyupeng.exception.RpcException;
import cn.fyupeng.loadbalancer.LoadBalancer;
import cn.fyupeng.util.IpUtils;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingFactory;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.common.utils.StringUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosUtils {
    private static final Logger log = LoggerFactory.getLogger(NacosUtils.class);
    private static final Set<String> serviceNames = new HashSet<String>();
    private static LoadBalancer loadBalancer;
    private static String SERVER_ADDR;
    private static NamingService namingService;
    private static InetSocketAddress inetSocketAddress;

    public static void init() {
        log.debug("nacos Services has initialize successfully!");
    }

    public static NamingService getNacosNamingService() {
        try {
            return NamingFactory.createNamingService((String)SERVER_ADDR);
        }
        catch (NacosException e) {
            log.error("error occurred when connecting to nacos server: ", (Throwable)e);
            return null;
        }
    }

    public static List<Instance> getAllInstance(String serviceName) throws NacosException {
        return namingService.getAllInstances(serviceName);
    }

    public static List<Instance> getAllInstance(String serviceName, String groupName) throws NacosException {
        return namingService.getAllInstances(serviceName, groupName);
    }

    public static void registerService(String serviceName, InetSocketAddress address) throws NacosException {
        namingService.registerInstance(serviceName, address.getHostName(), address.getPort());
        log.info("host[{}], service[{}] has been registered on Register Center", (Object)address.getHostName(), (Object)serviceName);
        inetSocketAddress = address;
        serviceNames.add(serviceName);
    }

    public static void registerService(String serviceName, String groupName, InetSocketAddress address) throws NacosException {
        namingService.registerInstance(serviceName, groupName, address.getHostName(), address.getPort());
        log.info("host[{}], service[{}] has been registered on Register Center", (Object)address.getHostName(), (Object)serviceName);
        inetSocketAddress = address;
        serviceNames.add(serviceName);
    }

    public static void clearRegistry() {
        if (!serviceNames.isEmpty() && inetSocketAddress != null) {
            String hostname = inetSocketAddress.getHostName();
            int port = inetSocketAddress.getPort();
            for (String serviceName : serviceNames) {
                try {
                    namingService.deregisterInstance(serviceName, hostname, port);
                }
                catch (NacosException e) {
                    log.error("Failed to cancel service:{}, info:{}", (Object)serviceName, (Object)e);
                }
            }
            log.info("All services on the nacos service have been cleaned up successfully");
        }
    }

    static {
        SERVER_ADDR = "127.0.0.1:8848";
        Properties p = new Properties();
        String currentWorkPath = System.getProperty("user.dir");
        Object is = null;
        String[] nodes = null;
        ResourceBundle configResource = null;
        String useCluster = "";
        String balancer = "round";
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(currentWorkPath + "/config/resource.properties"));){
            configResource = new PropertyResourceBundle(bufferedReader);
            useCluster = configResource.getString("cn.fyupeng.nacos.cluster.use");
            if ("false".equals(useCluster) || "default".equals(useCluster) || StringUtils.isBlank((String)useCluster)) {
                log.info("begin start with single mode");
                nodes = new String[1];
                try {
                    nodes[0] = configResource.getString("cn.fyupeng.nacos.register-addr");
                }
                catch (MissingResourceException registerAddException) {
                    nodes[0] = SERVER_ADDR;
                    log.warn("nacos register address attribute is missing");
                    log.info("use default register address : " + SERVER_ADDR);
                }
            } else {
                if ("true".equals(useCluster)) {
                    log.info("cluster mode attribute is true and start with cluster mode");
                    try {
                        balancer = configResource.getString("cn.fyupeng.nacos.cluster.load-balancer");
                    }
                    catch (MissingResourceException loadBalancerException) {
                        log.info("nacos property attribute is missing: {}", (Object)loadBalancerException.getMessage());
                        log.info("use default loadBalancer : " + balancer);
                    }
                    try {
                        nodes = configResource.getString("cn.fyupeng.nacos.cluster.nodes").split("[;,|]");
                    }
                    catch (MissingResourceException clusterNodesException) {
                        log.error("nacos cluster nodes attribute is missing: ", (Throwable)clusterNodesException);
                        throw new RuntimeException("nacos cluster nodes attribute is missing!");
                    }
                }
                throw new RuntimeException("nacos cluster mode attribute is illegal!");
            }
            log.info("read resource from resource path: {}", (Object)(currentWorkPath + "/config/resource.properties"));
        }
        catch (MissingResourceException clusterUseException) {
            log.warn("nacos cluster use attribute is missing");
            log.info("begin start with default single mode");
            nodes = new String[1];
            try {
                String nacosRegisterAddr = configResource.getString("cn.fyupeng.nacos.register-addr");
                nodes[0] = StringUtils.isBlank((String)nacosRegisterAddr) ? SERVER_ADDR : nacosRegisterAddr;
            }
            catch (MissingResourceException registerAddException) {
                nodes[0] = SERVER_ADDR;
                log.warn("nacos register address attribute is missing");
                log.info("use default register address : " + SERVER_ADDR);
            }
        }
        catch (IOException ioException) {
            block56: {
                log.info("not found resource from resource path: {}", (Object)(currentWorkPath + "/config/resource.properties"));
                try {
                    ResourceBundle resource = ResourceBundle.getBundle("resource");
                    try {
                        useCluster = resource.getString("cn.fyupeng.nacos.cluster.use");
                        if ("false".equals(useCluster) || "default".equals(useCluster) || StringUtils.isBlank((String)useCluster)) {
                            log.info("begin start with default single mode");
                            nodes = new String[1];
                            try {
                                String nacosRegisterAddr = resource.getString("cn.fyupeng.nacos.register-addr");
                                nodes[0] = StringUtils.isBlank((String)nacosRegisterAddr) ? SERVER_ADDR : nacosRegisterAddr;
                            }
                            catch (MissingResourceException registerAddException) {
                                nodes[0] = SERVER_ADDR;
                                log.warn("nacos register address attribute is missing");
                                log.info("use default register address : " + SERVER_ADDR);
                            }
                            break block56;
                        }
                        if ("true".equals(useCluster)) {
                            log.info("cluster mode attribute is true and start with cluster mode");
                            try {
                                balancer = resource.getString("cn.fyupeng.nacos.cluster.load-balancer");
                            }
                            catch (MissingResourceException loadBalancerException) {
                                log.info("nacos property attribute is missing: {}", (Object)loadBalancerException.getMessage());
                                log.info("use default loadBalancer : " + balancer);
                            }
                            try {
                                nodes = resource.getString("cn.fyupeng.nacos.cluster.nodes").split("[;,|]");
                                break block56;
                            }
                            catch (MissingResourceException clusterNodesException) {
                                log.error("nacos cluster nodes attribute is missing: ", (Throwable)clusterNodesException);
                                throw new RuntimeException("nacos cluster nodes attribute is missing!");
                            }
                        }
                        throw new RuntimeException("nacos cluster mode attribute is illegal!");
                    }
                    catch (MissingResourceException clusterUseException) {
                        log.info("cluster mode attribute is missing and start with single mode");
                        nodes = new String[]{resource.getString("cn.fyupeng.nacos.register-addr")};
                    }
                }
                catch (MissingResourceException resourceException) {
                    log.info("not found resource from resource path: {}", (Object)"resource.properties");
                    log.info("Register center bind with default address {}", (Object)SERVER_ADDR);
                }
            }
            log.info("read resource from resource path: {}", (Object)"resource.properties");
        }
        int pre = -1;
        String host = "";
        Integer port = 0;
        String node = null;
        if ("random".equals(balancer)) {
            loadBalancer = LoadBalancer.getByCode(LoadBalancerCode.RANDOM.getCode());
            log.info("use { {} } loadBalancer", (Object)loadBalancer.getClass().getName());
        } else if ("round".equals(balancer)) {
            loadBalancer = LoadBalancer.getByCode(LoadBalancerCode.ROUNDROBIN.getCode());
            log.info("use { {} } loadBalancer", (Object)loadBalancer.getClass().getName());
        } else {
            log.error("naocs cluster loadBalancer attribute is illegal!");
            throw new RuntimeException("naocs cluster loadBalancer attribute is illegal!");
        }
        do {
            try {
                node = loadBalancer.selectNode(nodes);
                log.info("waiting for connection to the registration center...");
                pre = node.indexOf(":");
                if (pre > 0 && pre == node.lastIndexOf(":")) {
                    host = node.substring(0, pre);
                    boolean valid = IpUtils.valid(host);
                    if (valid) {
                        host = node.substring(0, pre);
                        port = Integer.parseInt(node.substring(pre + 1));
                        if (host.equals("localhost")) {
                            SERVER_ADDR = "127.0.0.1:" + port;
                            continue;
                        }
                        SERVER_ADDR = node;
                        continue;
                    }
                    log.error("wrong ip address: {}", (Object)node);
                    continue;
                }
                if (node.equals("")) continue;
                log.error("wrong ip address: {}", (Object)node);
            }
            catch (RpcException valid) {
                // empty catch block
            }
        } while ((namingService = NacosUtils.getNacosNamingService()).getServerStatus() == "DOWN");
        if (namingService.getServerStatus() == "UP") {
            log.info("Register center bind with address {}", (Object)node);
        } else if (nodes != null && nodes.length == 1) {
            log.error("SingleTon Register Center is down from {}", (Object)SERVER_ADDR);
        } else if (nodes != null && nodes.length != 1) {
            log.error("Cluster Register Center is down from ");
            log.error("---");
            for (int i = 0; i < nodes.length; ++i) {
                log.error("{}", (Object)nodes[i]);
            }
            log.error("---");
        } else {
            log.error("Service occupy Internal Errors");
        }
    }
}

