/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.idworker.utils;

import com.alibaba.nacos.common.utils.StringUtils;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.SetArgs;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.DefaultClientResources;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.time.Duration;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LRedisHelper {
    private static final Logger log;
    private static Object lock;
    private static final String workerIds = "worker-ids";
    private static final String workerIdsSet = "worker-ids-set";
    private static final String retryReqIds = "retry-req-ids";
    private static StatefulRedisConnection<String, byte[]> strToByteConn;
    private static StatefulRedisConnection<String, String> strToStrConn;
    private static RedisAsyncCommands<String, byte[]> strToByteAsyncCommand;
    private static RedisAsyncCommands<String, String> strToStrAsyncCommand;
    private static RedisCommands<String, byte[]> strToByteSyncCommand;
    private static RedisCommands<String, String> strToStrSyncCommand;
    private static final String DEFAULT_ADDRESS = "127.0.0.1:6379";

    public static void preLoad() {
        log.trace("trigger preload");
    }

    public static Long exists(String key) {
        return strToStrSyncCommand.exists((Object[])new String[]{key});
    }

    public static void syncSet(String key, String value) {
        log.debug("syncSet key[{}] - value[{}]", (Object)key, (Object)value);
        strToStrSyncCommand.set((Object)key, (Object)value);
    }

    public static void asyncSet(String key, String value) {
        log.debug("asyncSet key[{}] - value[{}]", (Object)key, (Object)value);
        strToStrAsyncCommand.set((Object)key, (Object)value);
    }

    public static String get(String key) {
        String value = (String)strToStrSyncCommand.get((Object)key);
        log.debug("get key[{}] - value[{}]", (Object)key, (Object)value);
        return value;
    }

    public static boolean existsWorkerIdSet(long workerId) {
        return strToStrSyncCommand.sismember((Object)workerIdsSet, (Object)String.valueOf(workerId));
    }

    public static void syncSetWorkerIdSet(String workerId) {
        strToStrSyncCommand.sadd((Object)workerIdsSet, (Object[])new String[]{workerId});
    }

    public static void asyncSetWorkerIdSet(long workerId) {
        log.debug("asyncSetWorkerIdSet set[{}] - value[{}]", (Object)workerIdsSet, (Object)workerId);
        strToStrAsyncCommand.sadd((Object)workerIdsSet, (Object[])new String[]{String.valueOf(workerId)});
    }

    public static Long existsWorkerId(String hostName) {
        return strToStrSyncCommand.exists((Object[])new String[]{"worker-ids:" + hostName});
    }

    public static String getForHostName(String hostName) {
        String value = (String)strToStrSyncCommand.get((Object)("worker-ids:" + hostName));
        log.debug("getForHostName key[{}] - value[{}]", (Object)hostName, (Object)value);
        return value;
    }

    public static void asyncSetWorkerId(String hostName, long workerId) {
        log.debug("asyncSetWorkerId key[{}] - value[{}]", (Object)hostName, (Object)workerId);
        strToStrAsyncCommand.set((Object)("worker-ids:" + hostName), (Object)String.valueOf(workerId));
    }

    public static void syncSetWorkerId(String hostName, long workerId) {
        log.debug("syncSetWorkerId key[{}] - value[{}]", (Object)hostName, (Object)workerId);
        strToStrSyncCommand.set((Object)("worker-ids:" + hostName), (Object)String.valueOf(workerId));
    }

    public static Long existsRetryResult(String retryRequestId) {
        return strToStrSyncCommand.exists((Object[])new String[]{"retry-req-ids:" + retryRequestId});
    }

    public static byte[] getForRetryRequestId(String retryRequestId) {
        byte[] value = (byte[])strToByteSyncCommand.get((Object)("retry-req-ids:" + retryRequestId));
        log.debug("getForRetryRequestId key[{}] - value[{}]", (Object)retryRequestId, (Object)value);
        return value;
    }

    public static void asyncSetRetryRequestResult(String retryRequestId, byte[] result) {
        log.debug("asyncSetRetryRequestResult key[{}] - value[{}]", (Object)retryRequestId, (Object)result);
        strToByteAsyncCommand.set((Object)("retry-req-ids:" + retryRequestId), (Object)result, new SetArgs().nx().ex(60L));
    }

    public static void syncSetRetryRequestResult(String retryRequestId, byte[] result) {
        log.debug("syncSetRetryRequestResult key[{}] - value[{}]", (Object)retryRequestId, (Object)result);
        strToByteSyncCommand.set((Object)("retry-req-ids:" + retryRequestId), (Object)result, new SetArgs().nx().ex(60L));
    }

    public static void main(String[] args) {
    }

    static {
        String[] hostAndPort;
        String[] hostAndPort2;
        log = LoggerFactory.getLogger(LRedisHelper.class);
        lock = new Object();
        log.info("The lettuce thread pool is begin prepare");
        RedisURI.Builder uriBuilder = RedisURI.builder();
        Properties p = new Properties();
        String currentWorkPath = System.getProperty("user.dir");
        Object is = null;
        ResourceBundle configResource = null;
        String redisAuth = "";
        String redisPwd = "";
        String redisAddr = "";
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(currentWorkPath + "/config/resource.properties"));){
            configResource = new PropertyResourceBundle(bufferedReader);
            redisAuth = configResource.getString("cn.fyupeng.redis.server-auth");
            if ("false".equals(redisAuth) || "default".equals(redisAuth) || StringUtils.isBlank((String)redisAuth)) {
                log.info("--- no redis auth ---");
                try {
                    redisAddr = configResource.getString("cn.fyupeng.redis.server-addr");
                    hostAndPort2 = redisAddr.split(":");
                    uriBuilder.withHost(hostAndPort2[0]).withPort(Integer.parseInt(hostAndPort2[1]));
                }
                catch (MissingResourceException redisServerAddressException) {
                    hostAndPort = DEFAULT_ADDRESS.split(":");
                    uriBuilder.withHost(hostAndPort[0]).withPort(Integer.parseInt(hostAndPort[1]));
                    log.warn("redis server address attribute is missing");
                    log.info("use default redis server address : 127.0.0.1:6379");
                }
            } else {
                if ("true".equals(redisAuth)) {
                    log.info("redis auth attribute is true and start with auth");
                    try {
                        redisAddr = configResource.getString("cn.fyupeng.redis.server-addr");
                    }
                    catch (MissingResourceException redisServerAddressException) {
                        log.info("redis server address property attribute is missing: {}", (Object)redisServerAddressException.getMessage());
                        log.info("use default redis server address : 127.0.0.1:6379");
                        hostAndPort = DEFAULT_ADDRESS.split(":");
                        uriBuilder.withHost(hostAndPort[0]).withPort(Integer.parseInt(hostAndPort[1]));
                    }
                    try {
                        redisPwd = configResource.getString("cn.fyupeng.redis.server-pwd");
                        hostAndPort2 = redisAddr.split(":");
                        uriBuilder.withHost(hostAndPort2[0]).withPort(Integer.parseInt(hostAndPort2[1])).withAuthentication("default", (CharSequence)redisPwd);
                    }
                    catch (MissingResourceException redisPasswordException) {
                        log.error("redis password attribute is missing: ", (Throwable)redisPasswordException);
                        throw new RuntimeException("redis password attribute is missing!");
                    }
                }
                throw new RuntimeException("redis auth attribute is illegal!");
            }
            log.info("read resource from resource path: {}", (Object)(currentWorkPath + "/config/resource.properties"));
        }
        catch (MissingResourceException redisAuthException) {
            log.warn("redis auth attribute is missing and start with no auth");
            try {
                String redisAddress = configResource.getString("cn.fyupeng.redis.server-addr");
                redisAddr = StringUtils.isBlank((String)redisAddress) ? DEFAULT_ADDRESS : redisAddress;
                hostAndPort2 = redisAddr.split(":");
                uriBuilder.withHost(hostAndPort2[0]).withPort(Integer.parseInt(hostAndPort2[1]));
            }
            catch (MissingResourceException redisServerAddressException) {
                hostAndPort2 = DEFAULT_ADDRESS.split(":");
                uriBuilder.withHost(hostAndPort2[0]).withPort(Integer.parseInt(hostAndPort2[1]));
                log.warn("redis server address attribute is missing");
                log.info("use default redis server address : 127.0.0.1:6379");
            }
        }
        catch (IOException ioException) {
            block39: {
                log.info("not found resource from resource path: {}", (Object)(currentWorkPath + "/config/resource.properties"));
                try {
                    ResourceBundle resource = ResourceBundle.getBundle("resource");
                    try {
                        redisAuth = resource.getString("cn.fyupeng.redis.server-auth");
                        if ("false".equals(redisAuth) || "default".equals(redisAuth) || StringUtils.isBlank((String)redisAuth)) {
                            log.info("--- no redis auth ---");
                            try {
                                redisAddr = resource.getString("cn.fyupeng.redis.server-addr");
                                hostAndPort2 = redisAddr.split(":");
                                uriBuilder.withHost(hostAndPort2[0]).withPort(Integer.parseInt(hostAndPort2[1]));
                            }
                            catch (MissingResourceException redisServerAddressException) {
                                hostAndPort = DEFAULT_ADDRESS.split(":");
                                uriBuilder.withHost(hostAndPort[0]).withPort(Integer.parseInt(hostAndPort[1]));
                                log.warn("redis server address attribute is missing");
                                log.info("use default redis server address : 127.0.0.1:6379");
                            }
                            break block39;
                        }
                        if ("true".equals(redisAuth)) {
                            log.info("redis auth attribute is true and start with auth");
                            try {
                                redisAddr = resource.getString("cn.fyupeng.redis.server-addr");
                            }
                            catch (MissingResourceException redisServerAddressException) {
                                log.info("redis server address property attribute is missing: {}", (Object)redisServerAddressException.getMessage());
                                log.info("use default redis server address : 127.0.0.1:6379");
                                hostAndPort = DEFAULT_ADDRESS.split(":");
                                uriBuilder.withHost(hostAndPort[0]).withPort(Integer.parseInt(hostAndPort[1]));
                            }
                            try {
                                redisPwd = resource.getString("cn.fyupeng.redis.server-pwd");
                                hostAndPort2 = redisAddr.split(":");
                                uriBuilder.withHost(hostAndPort2[0]).withPort(Integer.parseInt(hostAndPort2[1])).withAuthentication("default", (CharSequence)redisPwd);
                                break block39;
                            }
                            catch (MissingResourceException redisPasswordException) {
                                log.error("redis password attribute is missing: ", (Throwable)redisPasswordException);
                                throw new RuntimeException("redis password attribute is missing!");
                            }
                        }
                        throw new RuntimeException("redis auth attribute is illegal!");
                    }
                    catch (MissingResourceException clusterUseException) {
                        log.info("redis auth attribute is missing and start with no auth");
                        redisAddr = resource.getString("cn.fyupeng.redis.server-addr");
                        hostAndPort = redisAddr.split(":");
                        uriBuilder.withHost(hostAndPort[0]).withPort(Integer.parseInt(hostAndPort[1]));
                    }
                }
                catch (MissingResourceException resourceException) {
                    log.info("not found resource from resource path: {}", (Object)"resource.properties");
                    log.info("Connect to default address {}", (Object)DEFAULT_ADDRESS);
                    hostAndPort2 = DEFAULT_ADDRESS.split(":");
                    uriBuilder.withHost(hostAndPort2[0]).withPort(Integer.parseInt(hostAndPort2[1]));
                }
            }
            log.info("read resource from resource path: {}", (Object)"resource.properties");
        }
        RedisURI uri = uriBuilder.build();
        DefaultClientResources resources = DefaultClientResources.builder().ioThreadPoolSize(4).computationThreadPoolSize(4).build();
        RedisClient client = RedisClient.create((ClientResources)resources, (RedisURI)uri);
        ClientOptions options = ClientOptions.builder().autoReconnect(true).pingBeforeActivateConnection(true).build();
        client.setOptions(options);
        client.setDefaultTimeout(Duration.ofSeconds(5L));
        strToByteConn = client.connect(RedisCodec.of((RedisCodec)new StringCodec(), (RedisCodec)new ByteArrayCodec()));
        strToStrConn = client.connect();
        strToByteAsyncCommand = strToByteConn.async();
        strToStrAsyncCommand = strToStrConn.async();
        strToByteSyncCommand = strToByteConn.sync();
        strToStrSyncCommand = strToStrConn.sync();
        log.info("The lettuce thread pool is ready");
    }
}

