/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.util;

import cn.fyupeng.util.CitySN;
import cn.fyupeng.util.JsonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpUtils {
    private static final Logger log = LoggerFactory.getLogger(IpUtils.class);

    public static boolean valid(String ip) {
        if (ip.equals("localhost")) {
            return true;
        }
        String z = ip.replace(".", "");
        int x = ip.length() - z.length();
        int t = ip.indexOf("..");
        if (t < 0) {
            boolean y = z.matches("[0-9]+");
            if (!(y && Character.isDigit(ip.charAt(0)) && Character.isDigit(ip.charAt(ip.length() - 1)))) {
                return false;
            }
            if (x == 3) {
                int b = ip.indexOf(46);
                String c = ip.substring(0, ip.indexOf(46));
                int i = Integer.parseInt(c);
                String d = ip.substring(b + 1);
                int e = d.indexOf(46);
                String f = d.substring(0, e);
                int j = Integer.parseInt(f);
                String g = d.substring(e + 1);
                int h = g.indexOf(46);
                String l = g.substring(0, h);
                int k = Integer.parseInt(l);
                String m = g.substring(h + 1);
                int n = Integer.parseInt(m);
                return i >= 0 && i <= 255 && j >= 0 && j <= 255 && k >= 0 && k <= 255 && n >= 0 && n <= 255;
            }
            return false;
        }
        return false;
    }

    public static String getPubIpAddr() {
        String ip = "";
        String chinaz = "https://ip.chinaz.com";
        StringBuilder inputLine = new StringBuilder();
        String read = "";
        URL url = null;
        HttpURLConnection urlConnection = null;
        BufferedReader in = null;
        try {
            url = new URL(chinaz);
            urlConnection = (HttpURLConnection)url.openConnection();
            in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "UTF-8"));
            while ((read = in.readLine()) != null) {
                inputLine.append(read + "\r\n");
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("get public IP address error: ", e);
        }
        catch (IOException e) {
            throw new RuntimeException("get public IP address error: " + e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        Pattern p = Pattern.compile("\\<dd class\\=\"fz24\">(.*?)\\<\\/dd>");
        Matcher m = p.matcher(inputLine.toString());
        if (m.find()) {
            String ipstr;
            ip = ipstr = m.group(1);
        }
        return ip;
    }

    public static String getPubIpAddr0() {
        try {
            URL url = new URL("https://pv.sohu.com/cityjson?ie=utf-8");
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            String s = "";
            StringBuffer sb = new StringBuffer("");
            String webContent = "";
            while ((s = br.readLine()) != null) {
                sb.append(s + "\r\n");
            }
            br.close();
            webContent = sb.toString();
            int start = webContent.indexOf("{");
            int end = webContent.indexOf("}") + 1;
            webContent = webContent.substring(start, end);
            CitySN target = JsonUtils.jsonToPojo(webContent, CitySN.class);
            return target.getCip();
        }
        catch (Exception e) {
            log.warn("Primary interface query failed, secondary interface query is being called");
            return IpUtils.getPubIpAddr1();
        }
    }

    private static String getPubIpAddr1() {
        String url = "https://ip.renfei.net/";
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Accept", "text/plain");
        String result = "127.0.0.1";
        try {
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (statusCode != 200) {
                log.error("statusCode={}", (Object)statusCode);
                log.error("responseEntity={}", (Object)response.getEntity());
                response.close();
                throw new RuntimeException("get public IP address error");
            }
            result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
        }
        catch (IOException e) {
            throw new RuntimeException("get public IP address error");
        }
        return result;
    }

    public static String getInterIP1() throws Exception {
        return InetAddress.getLocalHost().getHostAddress();
    }

    public static String getInterIP2() throws SocketException {
        String localip = null;
        String netip = null;
        Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
        InetAddress ip = null;
        boolean finded = false;
        block0: while (netInterfaces.hasMoreElements() && !finded) {
            NetworkInterface ni = netInterfaces.nextElement();
            Enumeration<InetAddress> address = ni.getInetAddresses();
            while (address.hasMoreElements()) {
                ip = address.nextElement();
                if (!ip.isSiteLocalAddress() && !ip.isLoopbackAddress() && ip.getHostAddress().indexOf(":") == -1) {
                    netip = ip.getHostAddress();
                    finded = true;
                    continue block0;
                }
                if (!ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().indexOf(":") != -1) continue;
                localip = ip.getHostAddress();
            }
        }
        if (netip != null && !"".equals(netip)) {
            return netip;
        }
        return localip;
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < 10; ++i) {
            String pubIpAddr = IpUtils.getPubIpAddr();
            System.out.println(pubIpAddr);
        }
    }
}

