/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.serializer;

import cn.fyupeng.enums.SerializerCode;
import cn.fyupeng.protocol.RpcRequest;
import cn.fyupeng.protocol.RpcResponse;
import cn.fyupeng.serializer.CommonSerializer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SJsonSerializer
implements CommonSerializer {
    private static final Logger log = LoggerFactory.getLogger(SJsonSerializer.class);
    private ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public byte[] serialize(Object obj) {
        byte[] data = null;
        try {
            data = this.objectMapper.writeValueAsBytes(obj);
        }
        catch (JsonProcessingException e) {
            log.error("Error occurred while serializing, info: {}", (Object)e.getMessage());
        }
        return data;
    }

    @Override
    public Object deserialize(byte[] data, Class<?> clazz) {
        if (data == null) {
            return null;
        }
        Object obj = null;
        try {
            obj = this.objectMapper.readValue(data, clazz);
            if (obj instanceof RpcRequest) {
                obj = this.validateAndHandlerRequest(obj);
            } else if (obj instanceof RpcResponse) {
                obj = this.validateAndHandlerResponse(obj, data);
            }
        }
        catch (IOException e) {
            log.error("Error occurred while deserializing, info: ", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return obj;
    }

    private Object validateAndHandlerRequest(Object obj) throws IOException, ClassNotFoundException {
        RpcRequest rpcRequest = (RpcRequest)obj;
        if (null == rpcRequest.getParamTypes()) {
            return obj;
        }
        for (int i = 0; i < rpcRequest.getParamTypes().length; ++i) {
            Class<?> clazz = Class.forName(rpcRequest.getParamTypes()[i]);
            if (clazz.isAssignableFrom(rpcRequest.getParameters()[i].getClass())) continue;
            byte[] bytes = this.objectMapper.writeValueAsBytes(rpcRequest.getParameters()[i]);
            rpcRequest.getParameters()[i] = this.objectMapper.readValue(bytes, clazz);
        }
        return rpcRequest;
    }

    private Object validateAndHandlerResponse(Object obj, byte[] data) throws IOException, ClassNotFoundException {
        RpcResponse rpcResponse = (RpcResponse)obj;
        if (null == rpcResponse.getDataType()) {
            return obj;
        }
        Class<?> clazz = Class.forName(rpcResponse.getDataType());
        if (!clazz.isAssignableFrom(rpcResponse.getData().getClass())) {
            byte[] bytes = this.objectMapper.writeValueAsBytes((Object)rpcResponse.getDataType());
            byte[] dataBytes = this.objectMapper.writeValueAsBytes(rpcResponse.getData());
            System.out.println(dataBytes);
            Object dataObject = this.objectMapper.readValue(bytes, clazz);
            String s = this.objectMapper.readTree(data).path("data").asText();
            System.out.println(s);
            ObjectMapper objectMapper = new ObjectMapper();
            RpcResponse response = (RpcResponse)objectMapper.readValue(dataBytes, new TypeReference<RpcResponse<?>>(){});
            Object myObject = response.getData();
            if (clazz.isInstance(data)) {
                dataObject = objectMapper.readValue(bytes, clazz);
            }
        }
        return rpcResponse;
    }

    @Override
    public int getCode() {
        return SerializerCode.valueOf(SerializerCode.SJSON.name()).getCode();
    }
}

