/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.config;

import cn.fyupeng.config.Configuration;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyConfiguration
implements Configuration {
    private static final Logger log = LoggerFactory.getLogger(NettyConfiguration.class);
    private static Integer frameLength = 50000;

    public static int getNettyFrameLength() {
        return frameLength;
    }

    static {
        String currentWorkPath = System.getProperty("user.dir");
        PropertyResourceBundle configResource = null;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(currentWorkPath + "/config/resource.properties"));){
            configResource = new PropertyResourceBundle(bufferedReader);
            String nettyFrameLength = configResource.getString("cn.fyupeng.netty.frame-length");
            int nettyFrameLengthValue = 0;
            try {
                nettyFrameLengthValue = Integer.parseInt(nettyFrameLength);
            }
            catch (Exception e) {
                log.warn("netty frameLength must be Integer, current value is {}", (Object)nettyFrameLength);
                log.info("use default FrameLength {}", (Object)frameLength);
            }
            if (nettyFrameLengthValue != 0) {
                frameLength = nettyFrameLengthValue;
            }
            log.info("read resource from resource path: {}", (Object)(currentWorkPath + "/config/resource.properties"));
        }
        catch (MissingResourceException frameLengthUseException) {
            log.info("netty frameLength is missing and use default value {}", (Object)frameLength);
        }
        catch (IOException ioException) {
            log.info("not found resource from resource path: {}", (Object)(currentWorkPath + "/config/resource.properties"));
            try {
                ResourceBundle resource = ResourceBundle.getBundle("resource");
                String nettyFrameLength = resource.getString("cn.fyupeng.netty.frame-length");
                int nettyFrameLengthValue = 0;
                try {
                    try {
                        nettyFrameLengthValue = Integer.parseInt(nettyFrameLength);
                    }
                    catch (Exception e) {
                        log.warn("netty frameLength must be Integer, current value is {}", (Object)nettyFrameLength);
                        log.info("use default FrameLength {}", (Object)frameLength);
                    }
                    if (nettyFrameLengthValue != 0) {
                        frameLength = nettyFrameLengthValue;
                    }
                }
                catch (MissingResourceException frameLengthUseException) {
                    log.info("netty frameLength is missing and use default value {}", (Object)frameLength);
                }
            }
            catch (MissingResourceException resourceException) {
                log.info("not found resource from resource path: {}", (Object)"resource.properties");
                log.info("use default FrameLength {}", (Object)frameLength);
            }
        }
        log.info("read resource from resource path: {}", (Object)"resource.properties");
        log.info("------------ netty Configuration \u3010 begin \u3011 ------------");
        log.info("frameLength: [{}]", (Object)frameLength);
        log.info("------------ netty Configuration \u3010 end \u3011 ------------");
    }
}

