/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.protocol;

import cn.fyupeng.enums.ResponseCode;
import cn.fyupeng.exception.ReceiveResponseException;
import cn.fyupeng.exception.RpcException;
import cn.fyupeng.protocol.RpcRequest;
import cn.fyupeng.protocol.RpcResponse;
import cn.fyupeng.serializer.CommonSerializer;
import cn.fyupeng.util.AesEncoder;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcMessageChecker {
    private static final Logger log = LoggerFactory.getLogger(RpcMessageChecker.class);
    private static final CommonSerializer serializer = CommonSerializer.getByCode(CommonSerializer.JSON_SERIALIZER);

    public static boolean check(RpcRequest rpcRequest, RpcResponse rpcResponse) throws RpcException {
        String checkCode;
        if (rpcResponse == null) {
            log.error("service call failed, service: {}", (Object)rpcRequest.getInterfaceName());
            return false;
        }
        if (!rpcResponse.getRequestId().equals(rpcRequest.getRequestId())) {
            log.error("inconsistent request numbers");
            return false;
        }
        if (rpcResponse.getStatusCode() == null || !rpcResponse.getStatusCode().equals(ResponseCode.SUCCESS.getCode())) {
            log.error("service call failed, service: {}", (Object)rpcRequest.getInterfaceName());
            return false;
        }
        if (rpcResponse.getData() == null) {
            checkCode = null;
        } else {
            byte[] checkData = serializer.serialize(rpcResponse.getData());
            checkCode = AesEncoder.encrypt(new String(checkData));
        }
        if (rpcResponse.getCheckCode() == null) {
            if (!Objects.equals(checkCode, rpcResponse.getCheckCode())) {
                log.error("data in package is modified\uff0c data: {}", rpcResponse.getData());
                log.error("detail modification information: {}\uff0cthe modification information has been filtered, and such messages will not be received and consumed\uff01", (Object)rpcResponse.getData().toString());
                return false;
            }
        } else if (!StringUtils.equals((CharSequence)RpcMessageChecker.removeSpecialChars(checkCode), (CharSequence)RpcMessageChecker.removeSpecialChars(rpcResponse.getCheckCode()))) {
            log.error("data in package is modified\uff0c data:{}", rpcResponse.getData());
            log.error("detail modification information: {}\uff0cthe modification information has been filtered, and such messages will not be received and consumed\uff01", (Object)rpcResponse.getData().toString());
            return false;
        }
        log.debug("Packet verification succeeded!");
        return true;
    }

    public static void checkAndThrow(RpcRequest rpcRequest, RpcResponse rpcResponse) throws RpcException {
        String checkCode;
        if (rpcResponse == null) {
            log.error("service call failed, service: {}", (Object)rpcRequest.getInterfaceName());
            throw new ReceiveResponseException("service call failed Exception");
        }
        if (!rpcResponse.getRequestId().equals(rpcRequest.getRequestId())) {
            log.error("inconsistent request numbers");
            throw new ReceiveResponseException("inconsistent request numbers Exception");
        }
        if (rpcResponse.getStatusCode() == null || !rpcResponse.getStatusCode().equals(ResponseCode.SUCCESS.getCode())) {
            log.error("service call failed, service: {}", (Object)rpcRequest.getInterfaceName());
            throw new ReceiveResponseException("service call failed Exception");
        }
        if (rpcResponse.getData() == null) {
            checkCode = null;
        } else {
            byte[] checkData = serializer.serialize(rpcResponse.getData());
            checkCode = AesEncoder.encrypt(new String(checkData));
        }
        if (rpcResponse.getCheckCode() == null) {
            if (!Objects.equals(checkCode, rpcResponse.getCheckCode())) {
                log.error("data in package is modified\uff0c data: {}", rpcResponse.getData());
                log.error("detail modification information: {}\uff0cthe modification information has been filtered, and such messages will not be received and consumed\uff01", (Object)rpcResponse.getData().toString());
                throw new ReceiveResponseException("data in package is modified Exception");
            }
        } else if (!StringUtils.equals((CharSequence)RpcMessageChecker.removeSpecialChars(checkCode), (CharSequence)RpcMessageChecker.removeSpecialChars(rpcResponse.getCheckCode()))) {
            log.error("data in package is modified\uff0c data:{}", rpcResponse.getData());
            log.error("detail modification information: {}\uff0cthe modification information has been filtered, and such messages will not be received and consumed\uff01", (Object)rpcResponse.getData().toString());
            throw new ReceiveResponseException("data in package is modified Exception");
        }
        log.debug("Packet verification succeeded!");
    }

    private static String removeSpecialChars(String input) {
        return StringUtils.replaceChars((String)input, (String)"_-+/", (String)"");
    }
}

