/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.proxy;

import cn.fyupeng.net.RpcClient;
import cn.fyupeng.net.netty.client.NettyClient;
import cn.fyupeng.net.socket.client.SocketClient;
import cn.fyupeng.protocol.RpcRequest;
import cn.fyupeng.protocol.RpcResponse;
import cn.fyupeng.util.RpcMessageChecker;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcClientProxy
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(RpcClientProxy.class);
    private RpcClient rpcClient;

    public RpcClientProxy(RpcClient rpcClient) {
        this.rpcClient = rpcClient;
    }

    public <T> T getProxy(Class<T> clazz) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        log.info("invoke method:{}#{}", (Object)method.getDeclaringClass().getName(), (Object)method.getName());
        RpcRequest rpcRequest = new RpcRequest.Builder().requestId(UUID.randomUUID().toString()).interfaceName(method.getDeclaringClass().getName()).methodName(method.getName()).parameters(args).paramTypes((Class[])method.getParameterTypes()).heartBeat(Boolean.valueOf(false)).build();
        RpcResponse rpcResponse = null;
        if (this.rpcClient instanceof NettyClient) {
            CompletableFuture completableFuture = (CompletableFuture)this.rpcClient.sendRequest(rpcRequest);
            rpcResponse = (RpcResponse)completableFuture.get();
        }
        System.out.println(rpcResponse);
        if (this.rpcClient instanceof SocketClient) {
            rpcResponse = (RpcResponse)this.rpcClient.sendRequest(rpcRequest);
        }
        RpcMessageChecker.check((RpcRequest)rpcRequest, (RpcResponse)rpcResponse);
        return rpcResponse.getData();
    }
}

