/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.net;

import cn.fyupeng.anotion.Service;
import cn.fyupeng.anotion.ServiceScan;
import cn.fyupeng.exception.AnnotationMissingException;
import cn.fyupeng.exception.RpcException;
import cn.fyupeng.net.RpcServer;
import cn.fyupeng.provider.ServiceProvider;
import cn.fyupeng.registry.ServiceRegistry;
import cn.fyupeng.util.ReflectUtil;
import java.net.InetSocketAddress;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRpcServer
implements RpcServer {
    private static final Logger log = LoggerFactory.getLogger(AbstractRpcServer.class);
    protected String hostName;
    protected int port;
    protected ServiceProvider serviceProvider;
    protected ServiceRegistry serviceRegistry;

    public void scanServices() throws RpcException {
        Class<?> startClass;
        String mainClassName = ReflectUtil.getStackTrace();
        try {
            startClass = Class.forName(mainClassName);
            if (!startClass.isAnnotationPresent(ServiceScan.class)) {
                log.error("The startup class is missing the @ServiceScan annotation");
                throw new AnnotationMissingException("The startup class is missing the @ServiceScan annotation Exception");
            }
        }
        catch (ClassNotFoundException e) {
            log.error("An unknown error has occurred:{}", (Object)e.getMessage());
            throw new RpcException("An unknown error has occurred Exception");
        }
        String basePackage = startClass.getAnnotation(ServiceScan.class).value();
        if ("".equals(basePackage)) {
            basePackage = mainClassName.lastIndexOf(".") != -1 ? mainClassName.substring(0, mainClassName.lastIndexOf(".")) : mainClassName;
        }
        Set<Class<?>> classSet = ReflectUtil.getClasses(basePackage);
        for (Class<?> clazz : classSet) {
            Object obj;
            if (!clazz.isAnnotationPresent(Service.class)) continue;
            String serviceName = clazz.getAnnotation(Service.class).name();
            try {
                obj = clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                log.error("An error occurred while creating the {} : {}", (Object)clazz, (Object)e);
                continue;
            }
            if ("".equals(serviceName)) {
                Class<?>[] interfaces;
                for (Class<?> oneInterface : interfaces = clazz.getInterfaces()) {
                    this.publishService(obj, oneInterface.getCanonicalName());
                }
                continue;
            }
            this.publishService(obj, serviceName);
        }
    }

    @Override
    public <T> void publishService(T service, String serviceName) throws RpcException {
        this.serviceProvider.addServiceProvider(service, serviceName);
        this.serviceRegistry.register(serviceName, new InetSocketAddress(this.hostName, this.port));
    }
}

