/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.provider;

import cn.fyupeng.exception.ServiceNotFoundException;
import cn.fyupeng.exception.ServiceNotImplException;
import cn.fyupeng.provider.ServiceProvider;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServiceProvider
implements ServiceProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultServiceProvider.class);
    private static final Map<String, Object> serviceMap = new ConcurrentHashMap<String, Object>();
    private static final Set<String> registeredService = ConcurrentHashMap.newKeySet();

    @Override
    public synchronized <T> void addServiceProvider(T service, String serviceName) throws ServiceNotImplException {
        if (registeredService.contains(serviceName)) {
            return;
        }
        registeredService.add(serviceName);
        serviceMap.put(serviceName, service);
        log.info("\u5411\u63a5\u53e3: {} \u6ce8\u518c\u670d\u52a1: {} ", (Object)service.getClass().getInterfaces(), (Object)serviceName);
    }

    @Override
    public synchronized Object getServiceProvider(String serviceName) throws ServiceNotFoundException {
        Object service = serviceMap.get(serviceName);
        if (service == null) {
            throw new ServiceNotFoundException("Service Not Found Exception!");
        }
        return service;
    }
}

