/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.format;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.utils.AssemblyFileUtils;
import org.apache.maven.shared.filtering.MavenFileFilterRequest;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;

public class FileFormatter {
    private final Logger logger;
    private final AssemblerConfigurationSource configSource;

    public FileFormatter(AssemblerConfigurationSource configSource, Logger logger) {
        this.configSource = configSource;
        this.logger = logger;
    }

    public File format(File source, boolean filter, String lineEnding, String encoding) throws AssemblyFormattingException {
        return this.format(source, filter, lineEnding, this.configSource.getTemporaryRootDirectory(), encoding);
    }

    public File format(@Nonnull File source, boolean filter, String lineEnding, @Nullable File tempRoot, String encoding) throws AssemblyFormattingException {
        String lineEndingChars;
        AssemblyFileUtils.verifyTempDirectoryAvailability(tempRoot);
        File result = source;
        if (StringUtils.isEmpty(encoding) && filter) {
            this.logger.warn("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!");
        }
        if (filter) {
            result = this.doFileFilter(source, tempRoot, encoding, this.configSource.getEscapeString());
        }
        if ((lineEndingChars = AssemblyFileUtils.getLineEndingCharacters(lineEnding)) != null) {
            result = this.formatLineEndings(lineEndingChars, result, tempRoot, encoding);
        }
        return result;
    }

    private File doFileFilter(@Nonnull File source, @Nullable File tempRoot, String encoding, String escapeString) throws AssemblyFormattingException {
        try {
            File target = FileUtils.createTempFile(source.getName() + ".", ".filtered", tempRoot);
            boolean isPropertiesFile = source.getName().toLowerCase(Locale.ENGLISH).endsWith(".properties");
            MavenFileFilterRequest filterRequest = new MavenFileFilterRequest(source, target, true, this.configSource.getProject(), this.configSource.getFilters(), isPropertiesFile, encoding, this.configSource.getMavenSession(), null);
            filterRequest.setEscapeString(escapeString);
            filterRequest.setInjectProjectBuildFilters(true);
            this.configSource.getMavenFileFilter().copyFile(filterRequest);
            return target;
        }
        catch (MavenFilteringException e) {
            throw new AssemblyFormattingException("Error filtering file '" + source + "': " + e.getMessage(), e);
        }
    }

    private File formatLineEndings(String lineEndingChars, File source, File tempRoot, String encoding) throws AssemblyFormattingException {
        Reader contentReader = null;
        try {
            File target = FileUtils.createTempFile(source.getName() + ".", ".formatted", tempRoot);
            AssemblyFileUtils.convertLineEndings(source, target, lineEndingChars, null, encoding);
            File file = target;
            return file;
        }
        catch (FileNotFoundException e) {
            throw new AssemblyFormattingException("File to filter not found: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AssemblyFormattingException("Error line formatting file '" + source + "': " + e.getMessage(), e);
        }
        finally {
            IOUtil.close(contentReader);
        }
    }
}

