/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.io;

import java.io.File;
import org.apache.maven.shared.io.location.FileLocation;
import org.apache.maven.shared.io.location.Location;
import org.apache.maven.shared.io.location.LocatorStrategy;
import org.apache.maven.shared.io.logging.MessageHolder;

public class RelativeFileLocatorStrategy
implements LocatorStrategy {
    private File basedir;

    public RelativeFileLocatorStrategy(File basedir) {
        this.basedir = basedir;
    }

    public Location resolve(String locationSpecification, MessageHolder messageHolder) {
        File file = new File(this.basedir, locationSpecification);
        messageHolder.addInfoMessage("Searching for file location: " + file.getAbsolutePath());
        FileLocation location = null;
        if (file.exists()) {
            location = new FileLocation(file, locationSpecification);
        } else {
            messageHolder.addMessage("File: " + file.getAbsolutePath() + " does not exist.");
        }
        return location;
    }
}

