/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.PatternExcludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.PatternIncludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.StatisticsReportingArtifactFilter;
import org.codehaus.plexus.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilterUtils {
    private FilterUtils() {
    }

    public static void filterProjects(Set<MavenProject> projects, List<String> includes, List<String> excludes, boolean actTransitively, Logger logger) {
        ArrayList<PatternIncludesArtifactFilter> allFilters = new ArrayList<PatternIncludesArtifactFilter>();
        AndArtifactFilter filter = new AndArtifactFilter();
        if (!includes.isEmpty()) {
            PatternIncludesArtifactFilter includeFilter = new PatternIncludesArtifactFilter(includes, actTransitively);
            filter.add(includeFilter);
            allFilters.add(includeFilter);
        }
        if (!excludes.isEmpty()) {
            PatternExcludesArtifactFilter excludeFilter = new PatternExcludesArtifactFilter(excludes, actTransitively);
            filter.add(excludeFilter);
            allFilters.add(excludeFilter);
        }
        Iterator<MavenProject> it = projects.iterator();
        while (it.hasNext()) {
            MavenProject project = it.next();
            Artifact artifact = project.getArtifact();
            if (filter.include(artifact)) continue;
            it.remove();
        }
        for (PatternIncludesArtifactFilter f : allFilters) {
            if (f == null) continue;
            f.reportMissedCriteria(logger);
        }
    }

    public static void filterArtifacts(Set<Artifact> artifacts, List<String> includes, List<String> excludes, boolean strictFiltering, boolean actTransitively, Logger logger, ArtifactFilter ... additionalFilters) throws InvalidAssemblerConfigurationException {
        ArrayList<ArtifactFilter> allFilters = new ArrayList<ArtifactFilter>();
        AndArtifactFilter filter = new AndArtifactFilter();
        if (additionalFilters != null && additionalFilters.length > 0) {
            for (ArtifactFilter additionalFilter : additionalFilters) {
                if (additionalFilter == null) continue;
                filter.add(additionalFilter);
            }
        }
        if (!includes.isEmpty()) {
            PatternIncludesArtifactFilter includeFilter = new PatternIncludesArtifactFilter(includes, actTransitively);
            filter.add(includeFilter);
            allFilters.add(includeFilter);
        }
        if (!excludes.isEmpty()) {
            PatternExcludesArtifactFilter excludeFilter = new PatternExcludesArtifactFilter(excludes, actTransitively);
            filter.add(excludeFilter);
            allFilters.add(excludeFilter);
        }
        Iterator<Artifact> it = artifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = it.next();
            if (filter.include(artifact)) continue;
            it.remove();
            if (!logger.isDebugEnabled()) continue;
            logger.debug(artifact.getId() + " was removed by one or more filters.");
        }
        FilterUtils.reportFilteringStatistics(allFilters, logger);
        for (ArtifactFilter f : allFilters) {
            if (!(f instanceof StatisticsReportingArtifactFilter)) continue;
            StatisticsReportingArtifactFilter sFilter = (StatisticsReportingArtifactFilter)((Object)f);
            if (!strictFiltering || !sFilter.hasMissedCriteria()) continue;
            throw new InvalidAssemblerConfigurationException("One or more filters had unmatched criteria. Check debug log for more information.");
        }
    }

    public static void reportFilteringStatistics(Collection<ArtifactFilter> filters, Logger logger) {
        for (ArtifactFilter f : filters) {
            if (!(f instanceof StatisticsReportingArtifactFilter)) continue;
            StatisticsReportingArtifactFilter sFilter = (StatisticsReportingArtifactFilter)((Object)f);
            if (logger.isDebugEnabled()) {
                logger.debug("Statistics for " + sFilter + "\n");
            }
            sFilter.reportMissedCriteria(logger);
            sFilter.reportFilteredArtifacts(logger);
        }
    }
}

