/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.artifact.filter;

import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;

public abstract class AbstractStrictPatternArtifactFilter
implements ArtifactFilter {
    private final List patterns;
    private final boolean include;

    public AbstractStrictPatternArtifactFilter(List patterns, boolean include) {
        this.patterns = patterns;
        this.include = include;
    }

    public boolean include(Artifact artifact) {
        boolean matched = false;
        Iterator i = this.patterns.iterator();
        while (i.hasNext() & !matched) {
            String pattern = (String)i.next();
            if (!this.include(artifact, pattern)) continue;
            matched = true;
        }
        return this.include ? matched : !matched;
    }

    private boolean include(Artifact artifact, String pattern) {
        String[] tokens = new String[]{artifact.getGroupId(), artifact.getArtifactId(), artifact.getType(), artifact.getBaseVersion()};
        String[] patternTokens = pattern.split(":");
        boolean matched = patternTokens.length <= tokens.length;
        for (int i = 0; matched && i < patternTokens.length; ++i) {
            matched = this.matches(tokens[i], patternTokens[i]);
        }
        return matched;
    }

    private boolean matches(String token, String pattern) {
        boolean matches;
        if ("*".equals(pattern) || pattern.length() == 0) {
            matches = true;
        } else if (pattern.startsWith("*") && pattern.endsWith("*")) {
            String contains = pattern.substring(1, pattern.length() - 1);
            matches = token.indexOf(contains) != -1;
        } else if (pattern.startsWith("*")) {
            String suffix = pattern.substring(1, pattern.length());
            matches = token.endsWith(suffix);
        } else if (pattern.endsWith("*")) {
            String prefix = pattern.substring(0, pattern.length() - 1);
            matches = token.startsWith(prefix);
        } else {
            matches = pattern.startsWith("[") || pattern.startsWith("(") ? this.isVersionIncludedInRange(token, pattern) : token.equals(pattern);
        }
        return matches;
    }

    private boolean isVersionIncludedInRange(String version, String range) {
        try {
            return VersionRange.createFromVersionSpec(range).containsVersion(new DefaultArtifactVersion(version));
        }
        catch (InvalidVersionSpecificationException e) {
            return false;
        }
    }
}

