/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.artifact.filter.collection;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.shared.artifact.filter.collection.AbstractArtifactsFilter;

public class ArtifactTransitivityFilter
extends AbstractArtifactsFilter {
    Collection transitiveArtifacts;
    ArtifactFactory factory;
    ArtifactRepository local;
    List remote;

    public ArtifactTransitivityFilter(Artifact artifact, ArtifactFactory factory, ArtifactRepository local, List remote, MavenProjectBuilder builder) throws ProjectBuildingException, InvalidDependencyVersionException {
        this.factory = factory;
        this.local = local;
        this.remote = remote;
        Artifact rootArtifactPom = factory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "", "pom");
        MavenProject rootArtifactProject = builder.buildFromRepository(rootArtifactPom, remote, local);
        this.transitiveArtifacts = rootArtifactProject.createArtifacts(this.factory, "test", new ScopeArtifactFilter("test"));
    }

    public ArtifactTransitivityFilter(Dependency dependency, ArtifactFactory factory, ArtifactRepository local, List remote, MavenProjectBuilder builder) throws ProjectBuildingException, InvalidDependencyVersionException {
        this.factory = factory;
        this.local = local;
        this.remote = remote;
        Artifact rootArtifactPom = factory.createArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), "", "pom");
        MavenProject rootArtifactProject = builder.buildFromRepository(rootArtifactPom, remote, local);
        this.transitiveArtifacts = rootArtifactProject.createArtifacts(this.factory, "test", new ScopeArtifactFilter("test"));
    }

    public Set filter(Set artifacts) {
        HashSet<Artifact> result = new HashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            if (!this.artifactIsATransitiveDependency(artifact)) continue;
            result.add(artifact);
        }
        return result;
    }

    public boolean artifactIsATransitiveDependency(Artifact artifact) {
        boolean result = false;
        for (Artifact trans : this.transitiveArtifacts) {
            if (!trans.getGroupId().equals(artifact.getGroupId()) || !trans.getArtifactId().equals(artifact.getArtifactId())) continue;
            result = true;
            break;
        }
        return result;
    }
}

