/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.model.fileset.mappers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.maven.shared.model.fileset.Mapper;
import org.apache.maven.shared.model.fileset.mappers.FileNameMapper;
import org.apache.maven.shared.model.fileset.mappers.MapperException;
import org.codehaus.plexus.util.IOUtil;

public final class MapperUtil {
    private static final String MAPPER_PROPERTIES = "mapper.properties";
    private static Properties implementations;

    private MapperUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeBuiltIns() {
        if (implementations == null) {
            Properties props = new Properties();
            ClassLoader cloader = Thread.currentThread().getContextClassLoader();
            InputStream stream = null;
            try {
                stream = cloader.getResourceAsStream(MAPPER_PROPERTIES);
                if (stream == null) {
                    throw new IllegalStateException("Cannot find classpath resource: mapper.properties");
                }
                try {
                    props.load(stream);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Cannot find classpath resource: mapper.properties");
                }
            }
            finally {
                IOUtil.close(stream);
            }
        }
    }

    public static FileNameMapper getFileNameMapper(Mapper mapper) throws MapperException {
        if (mapper == null) {
            return null;
        }
        MapperUtil.initializeBuiltIns();
        String type = mapper.getType();
        String classname = mapper.getClassname();
        if (type == null && classname == null) {
            throw new MapperException("nested mapper or one of the attributes type or classname is required");
        }
        if (type != null && classname != null) {
            throw new MapperException("must not specify both type and classname attribute");
        }
        if (type != null) {
            classname = implementations.getProperty(type);
        }
        try {
            FileNameMapper m3 = (FileNameMapper)Class.forName(classname).newInstance();
            m3.setFrom(mapper.getFrom());
            m3.setTo(mapper.getTo());
            return m3;
        }
        catch (ClassNotFoundException e) {
            throw new MapperException("Cannot find mapper implementation: " + classname, e);
        }
        catch (InstantiationException e) {
            throw new MapperException("Cannot load mapper implementation: " + classname, e);
        }
        catch (IllegalAccessException e) {
            throw new MapperException("Cannot load mapper implementation: " + classname, e);
        }
    }
}

