/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.model.fileset.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.io.logging.DefaultMessageHolder;
import org.apache.maven.shared.io.logging.MessageHolder;
import org.apache.maven.shared.io.logging.MojoLogSink;
import org.apache.maven.shared.io.logging.PlexusLoggerSink;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.mappers.FileNameMapper;
import org.apache.maven.shared.model.fileset.mappers.MapperException;
import org.apache.maven.shared.model.fileset.mappers.MapperUtil;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.DirectoryScanner;

public class FileSetManager {
    private static final int DELETE_RETRY_SLEEP_MILLIS = 10;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final boolean verbose;
    private MessageHolder messages;

    public FileSetManager(Log log, boolean verbose) {
        this.messages = verbose ? new DefaultMessageHolder(0, 1, new MojoLogSink(log)) : new DefaultMessageHolder(1, 1, new MojoLogSink(log));
        this.verbose = verbose;
    }

    public FileSetManager(Log log) {
        this.messages = new DefaultMessageHolder(1, 1, new MojoLogSink(log));
        this.verbose = false;
    }

    public FileSetManager(Logger log, boolean verbose) {
        this.messages = verbose ? new DefaultMessageHolder(0, 1, new PlexusLoggerSink(log)) : new DefaultMessageHolder(1, 1, new PlexusLoggerSink(log));
        this.verbose = verbose;
    }

    public FileSetManager(Logger log) {
        this.messages = new DefaultMessageHolder(1, 1, new PlexusLoggerSink(log));
        this.verbose = false;
    }

    public FileSetManager() {
        this.verbose = false;
    }

    public Map mapIncludedFiles(FileSet fileSet) throws MapperException {
        String[] sourcePaths = this.getIncludedFiles(fileSet);
        LinkedHashMap<String, String> mappedPaths = new LinkedHashMap<String, String>();
        FileNameMapper fileMapper = MapperUtil.getFileNameMapper(fileSet.getMapper());
        for (int i = 0; i < sourcePaths.length; ++i) {
            String sourcePath = sourcePaths[i];
            String destPath = fileMapper != null ? fileMapper.mapFileName(sourcePath) : sourcePath;
            mappedPaths.put(sourcePath, destPath);
        }
        return mappedPaths;
    }

    public String[] getIncludedFiles(FileSet fileSet) {
        DirectoryScanner scanner = this.scan(fileSet);
        if (scanner != null) {
            return scanner.getIncludedFiles();
        }
        return EMPTY_STRING_ARRAY;
    }

    public String[] getIncludedDirectories(FileSet fileSet) {
        DirectoryScanner scanner = this.scan(fileSet);
        if (scanner != null) {
            return scanner.getIncludedDirectories();
        }
        return EMPTY_STRING_ARRAY;
    }

    public String[] getExcludedFiles(FileSet fileSet) {
        DirectoryScanner scanner = this.scan(fileSet);
        if (scanner != null) {
            return scanner.getExcludedFiles();
        }
        return EMPTY_STRING_ARRAY;
    }

    public String[] getExcludedDirectories(FileSet fileSet) {
        DirectoryScanner scanner = this.scan(fileSet);
        if (scanner != null) {
            return scanner.getExcludedDirectories();
        }
        return EMPTY_STRING_ARRAY;
    }

    public void delete(FileSet fileSet) throws IOException {
        Set deletablePaths = this.findDeletablePaths(fileSet);
        if (this.messages != null && this.messages.isDebugEnabled()) {
            this.messages.addDebugMessage("Found deletable paths: " + String.valueOf(deletablePaths).replace(',', '\n'));
        }
        Iterator it = deletablePaths.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            File file = new File(fileSet.getDirectory(), path);
            if (!file.exists()) continue;
            if (file.isDirectory() && (fileSet.isFollowSymlinks() || !this.isSymlink(file))) {
                if (this.verbose && this.messages != null) {
                    this.messages.addInfoMessage("Deleting directory: " + file);
                }
                this.removeDir(file, fileSet.isFollowSymlinks());
                continue;
            }
            if (this.verbose && this.messages != null) {
                this.messages.addInfoMessage("Deleting file: " + file);
            }
            if (this.delete(file)) continue;
            throw new IOException("Failed to delete file: " + file + ". Reason is unknown.");
        }
    }

    private boolean isSymlink(File file) throws IOException {
        File parent = file.getParentFile();
        File canonicalFile = file.getCanonicalFile();
        if (this.messages != null && this.messages.isDebugEnabled()) {
            this.messages.addDebugMessage("Checking for symlink:\nParent file's canonical path: " + parent.getCanonicalPath() + "\nMy canonical path: " + canonicalFile.getPath());
        }
        return parent != null && (!canonicalFile.getName().equals(file.getName()) || !canonicalFile.getPath().startsWith(parent.getCanonicalPath()));
    }

    private Set findDeletablePaths(FileSet fileSet) {
        Set includes = this.findDeletableDirectories(fileSet);
        includes.addAll(this.findDeletableFiles(fileSet, includes));
        return includes;
    }

    private Set findDeletableDirectories(FileSet fileSet) {
        DirectoryScanner scanner;
        if (this.verbose && this.messages != null) {
            this.messages.addInfoMessage("Scanning for deletable directories.");
        }
        if ((scanner = this.scan(fileSet)) == null) {
            return Collections.EMPTY_SET;
        }
        String[] includedDirs = scanner.getIncludedDirectories();
        String[] excludedDirs = scanner.getExcludedDirectories();
        HashSet<String> includes = new HashSet<String>(Arrays.asList(includedDirs));
        ArrayList<String> excludes = new ArrayList<String>(Arrays.asList(excludedDirs));
        ArrayList<String> linksForDeletion = new ArrayList<String>();
        if (!fileSet.isFollowSymlinks()) {
            if (this.verbose && this.messages != null) {
                this.messages.addInfoMessage("Adding symbolic link dirs which were previously excluded to the list being deleted.");
            }
            scanner.setFollowSymlinks(true);
            scanner.scan();
            if (this.messages != null && this.messages.isDebugEnabled()) {
                this.messages.addDebugMessage("Originally marked for delete: " + includes);
                this.messages.addDebugMessage("Marked for preserve (with followSymlinks == false): " + excludes);
            }
            List<String> notSymlinks = Arrays.asList(scanner.getIncludedDirectories());
            linksForDeletion.addAll(excludes);
            linksForDeletion.retainAll(notSymlinks);
            if (this.messages != null && this.messages.isDebugEnabled()) {
                this.messages.addDebugMessage("Symlinks marked for deletion (originally mismarked): " + linksForDeletion);
            }
            excludes.removeAll(notSymlinks);
        }
        for (int i = 0; i < excludedDirs.length; ++i) {
            String path = excludedDirs[i];
            File excluded = new File(path);
            String parentPath = excluded.getParent();
            while (parentPath != null) {
                boolean removed;
                if (this.messages != null && this.messages.isDebugEnabled()) {
                    this.messages.addDebugMessage("Verifying path: " + parentPath + " is not present; contains file which is excluded.");
                }
                if ((removed = includes.remove(parentPath)) && this.messages != null && this.messages.isDebugEnabled()) {
                    this.messages.addDebugMessage("Path: " + parentPath + " was removed from delete list.");
                }
                parentPath = new File(parentPath).getParent();
            }
        }
        includes.addAll(linksForDeletion);
        return includes;
    }

    private Set findDeletableFiles(FileSet fileSet, Set deletableDirectories) {
        DirectoryScanner scanner;
        if (this.verbose && this.messages != null) {
            this.messages.addInfoMessage("Re-scanning for deletable files.");
        }
        if ((scanner = this.scan(fileSet)) == null) {
            return deletableDirectories;
        }
        String[] includedFiles = scanner.getIncludedFiles();
        String[] excludedFiles = scanner.getExcludedFiles();
        Set includes = deletableDirectories;
        includes.addAll(Arrays.asList(includedFiles));
        ArrayList<String> excludes = new ArrayList<String>(Arrays.asList(excludedFiles));
        ArrayList<String> linksForDeletion = new ArrayList<String>();
        if (!fileSet.isFollowSymlinks()) {
            if (this.verbose && this.messages != null) {
                this.messages.addInfoMessage("Adding symbolic link files which were previously excluded to the list being deleted.");
            }
            scanner.setFollowSymlinks(true);
            scanner.scan();
            if (this.messages != null && this.messages.isDebugEnabled()) {
                this.messages.addDebugMessage("Originally marked for delete: " + includes);
                this.messages.addDebugMessage("Marked for preserve (with followSymlinks == false): " + excludes);
            }
            List<String> notSymlinks = Arrays.asList(scanner.getExcludedFiles());
            linksForDeletion.addAll(excludes);
            linksForDeletion.retainAll(notSymlinks);
            if (this.messages != null && this.messages.isDebugEnabled()) {
                this.messages.addDebugMessage("Symlinks marked for deletion (originally mismarked): " + linksForDeletion);
            }
            excludes.removeAll(notSymlinks);
        }
        for (int i = 0; i < excludedFiles.length; ++i) {
            String path = excludedFiles[i];
            File excluded = new File(path);
            String parentPath = excluded.getParent();
            while (parentPath != null) {
                boolean removed;
                if (this.messages != null && this.messages.isDebugEnabled()) {
                    this.messages.addDebugMessage("Verifying path: " + parentPath + " is not present; contains file which is excluded.");
                }
                if ((removed = includes.remove(parentPath)) && this.messages != null && this.messages.isDebugEnabled()) {
                    this.messages.addDebugMessage("Path: " + parentPath + " was removed from delete list.");
                }
                parentPath = new File(parentPath).getParent();
            }
        }
        includes.addAll(linksForDeletion);
        return includes;
    }

    private void removeDir(File dir, boolean followSymlinks) throws IOException {
        String[] list = dir.list();
        if (list == null) {
            list = new String[]{};
        }
        for (int i = 0; i < list.length; ++i) {
            String s2 = list[i];
            File f = new File(dir, s2);
            if (f.isDirectory() && (followSymlinks || !this.isSymlink(f))) {
                this.removeDir(f, followSymlinks);
                continue;
            }
            if (this.delete(f)) continue;
            String message = "Unable to delete file " + f.getAbsolutePath();
            throw new IOException(message);
        }
        if (!this.delete(dir)) {
            String message = "Unable to delete directory " + dir.getAbsolutePath();
            throw new IOException(message);
        }
    }

    private boolean delete(File f) {
        if (!f.delete()) {
            if (System.getProperty("os.name").toLowerCase().indexOf("windows") > -1) {
                System.gc();
            }
            try {
                Thread.sleep(10L);
                return f.delete();
            }
            catch (InterruptedException ex) {
                return f.delete();
            }
        }
        return true;
    }

    private DirectoryScanner scan(FileSet fileSet) {
        File basedir = new File(fileSet.getDirectory());
        if (!basedir.exists() || !basedir.isDirectory()) {
            return null;
        }
        DirectoryScanner scanner = new DirectoryScanner();
        String[] includesArray = fileSet.getIncludesArray();
        String[] excludesArray = fileSet.getExcludesArray();
        if (includesArray.length > 0) {
            scanner.setIncludes(includesArray);
        }
        if (excludesArray.length > 0) {
            scanner.setExcludes(excludesArray);
        }
        if (fileSet.isUseDefaultExcludes()) {
            scanner.addDefaultExcludes();
        }
        scanner.setBasedir(basedir);
        scanner.setFollowSymlinks(fileSet.isFollowSymlinks());
        scanner.scan();
        return scanner;
    }
}

