/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.bzip2;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.util.Compressor;
import org.codehaus.plexus.util.IOUtil;

public class BZip2Compressor
extends Compressor {
    private BZip2CompressorOutputStream zOut;

    public void compress() throws ArchiverException {
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.getDestFile()));
            this.zOut = new BZip2CompressorOutputStream(bos);
            this.compress(this.getSource(), this.zOut);
        }
        catch (IOException ioe) {
            String msg = "Problem creating bzip2 " + ioe.getMessage();
            throw new ArchiverException(msg, ioe);
        }
    }

    public void close() {
        IOUtil.close(this.zOut);
        this.zOut = null;
    }
}

