/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.manager;

import java.io.File;
import java.util.Locale;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.components.io.resources.PlexusIoResourceCollection;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class DefaultArchiverManager
implements ArchiverManager,
Contextualizable {
    private PlexusContainer container;

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get("plexus");
    }

    public Archiver getArchiver(String archiverName) throws NoSuchArchiverException {
        try {
            return (Archiver)this.container.lookup(Archiver.ROLE, archiverName);
        }
        catch (ComponentLookupException e) {
            throw new NoSuchArchiverException(archiverName);
        }
    }

    public UnArchiver getUnArchiver(String unArchiverName) throws NoSuchArchiverException {
        try {
            return (UnArchiver)this.container.lookup(UnArchiver.ROLE, unArchiverName);
        }
        catch (ComponentLookupException e) {
            throw new NoSuchArchiverException(unArchiverName);
        }
    }

    public PlexusIoResourceCollection getResourceCollection(String resourceCollectionName) throws NoSuchArchiverException {
        try {
            return (PlexusIoResourceCollection)this.container.lookup(PlexusIoResourceCollection.ROLE, resourceCollectionName);
        }
        catch (ComponentLookupException e) {
            throw new NoSuchArchiverException(resourceCollectionName);
        }
    }

    private static String getFileExtention(File file) {
        String[] tokens;
        String path = file.getAbsolutePath();
        String archiveExt = FileUtils.getExtension(path).toLowerCase(Locale.ENGLISH);
        if (("gz".equals(archiveExt) || "bz2".equals(archiveExt)) && (tokens = StringUtils.split(path, ".")).length > 2 && "tar".equals(tokens[tokens.length - 2].toLowerCase(Locale.ENGLISH))) {
            archiveExt = "tar." + archiveExt;
        }
        return archiveExt;
    }

    public Archiver getArchiver(File file) throws NoSuchArchiverException {
        return this.getArchiver(DefaultArchiverManager.getFileExtention(file));
    }

    public UnArchiver getUnArchiver(File file) throws NoSuchArchiverException {
        return this.getUnArchiver(DefaultArchiverManager.getFileExtention(file));
    }

    public PlexusIoResourceCollection getResourceCollection(File file) throws NoSuchArchiverException {
        return this.getResourceCollection(DefaultArchiverManager.getFileExtention(file));
    }
}

