/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.util;

import java.io.File;
import java.lang.reflect.Method;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.util.FilePermission;
import org.codehaus.plexus.archiver.util.FilePermissionUtils;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public final class ArchiveEntryUtils {
    public static boolean jvmFilePermAvailable = false;

    private ArchiveEntryUtils() {
    }

    public static void chmod(File file, int mode, Logger logger, boolean useJvmChmod) throws ArchiverException {
        if (!Os.isFamily("unix")) {
            return;
        }
        String m3 = Integer.toOctalString(mode & 0xFFF);
        if (useJvmChmod && !jvmFilePermAvailable) {
            useJvmChmod = false;
        }
        if (useJvmChmod && jvmFilePermAvailable) {
            ArchiveEntryUtils.applyPermissionsWithJvm(file, m3, logger);
            return;
        }
        try {
            Commandline commandline = new Commandline();
            commandline.setWorkingDirectory(file.getParentFile().getAbsolutePath());
            if (logger.isDebugEnabled()) {
                logger.debug(file + ": mode " + Integer.toOctalString(mode) + ", chmod " + m3);
            }
            commandline.setExecutable("chmod");
            commandline.createArg().setValue(m3);
            String path = file.getAbsolutePath();
            commandline.createArg().setValue(path);
            CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
            CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
            int exitCode = CommandLineUtils.executeCommandLine(commandline, stderr, stdout);
            if (exitCode != 0) {
                logger.warn("-------------------------------");
                logger.warn("Standard error:");
                logger.warn("-------------------------------");
                logger.warn(stderr.getOutput());
                logger.warn("-------------------------------");
                logger.warn("Standard output:");
                logger.warn("-------------------------------");
                logger.warn(stdout.getOutput());
                logger.warn("-------------------------------");
                throw new ArchiverException("chmod exit code was: " + exitCode);
            }
        }
        catch (CommandLineException e) {
            throw new ArchiverException("Error while executing chmod.", e);
        }
    }

    public static void chmod(File file, int mode, Logger logger) throws ArchiverException {
        ArchiveEntryUtils.chmod(file, mode, logger, Boolean.getBoolean("useJvmChmod") && jvmFilePermAvailable);
    }

    private static void applyPermissionsWithJvm(File file, String mode, Logger logger) throws ArchiverException {
        FilePermission filePermission = FilePermissionUtils.getFilePermissionFromMode(mode, logger);
        try {
            Method method = File.class.getMethod("setReadable", Boolean.TYPE, Boolean.TYPE);
            method.invoke((Object)file, filePermission.isReadable(), filePermission.isOwnerOnlyReadable());
            method = File.class.getMethod("setExecutable", Boolean.TYPE, Boolean.TYPE);
            method.invoke((Object)file, filePermission.isExecutable(), filePermission.isOwnerOnlyExecutable());
            method = File.class.getMethod("setWritable", Boolean.TYPE, Boolean.TYPE);
            method.invoke((Object)file, filePermission.isWritable(), filePermission.isOwnerOnlyWritable());
        }
        catch (Exception e) {
            logger.error("error calling dynamically file permissons with jvm " + e.getMessage(), e);
            throw new ArchiverException("error calling dynamically file permissons with jvm " + e.getMessage(), e);
        }
    }

    static {
        try {
            jvmFilePermAvailable = File.class.getMethod("setReadable", Boolean.TYPE) != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

