/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.discovery;

import cn.fyupeng.discovery.ServiceDiscovery;
import cn.fyupeng.exception.ObtainServiceException;
import cn.fyupeng.exception.RpcException;
import cn.fyupeng.loadbalancer.LoadBalancer;
import cn.fyupeng.util.NacosUtils;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import java.net.InetSocketAddress;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosServiceDiscovery
implements ServiceDiscovery {
    private static final Logger log = LoggerFactory.getLogger(NacosServiceDiscovery.class);
    private final LoadBalancer loadBalancer;

    public NacosServiceDiscovery(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    @Override
    public InetSocketAddress lookupService(String serviceName) throws RpcException {
        try {
            List instances = NacosUtils.getAllInstance((String)serviceName);
            Instance instance = this.loadBalancer.select(instances);
            return new InetSocketAddress(instance.getIp(), instance.getPort());
        }
        catch (NacosException e) {
            log.error("error occurred while fetching the service:{}", (Object)e.getMessage());
            throw new ObtainServiceException("error occurred while fetching the service Exception");
        }
        catch (RpcException e) {
            log.error("service instances size is zero, can't provide service! please start server first! Exception: {}", (Object)e.getMessage());
            throw e;
        }
    }
}

