/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.handler;

import cn.fyupeng.exception.RpcException;
import cn.fyupeng.protocol.RpcRequest;
import cn.fyupeng.provider.DefaultServiceProvider;
import cn.fyupeng.provider.ServiceProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHandler {
    private static final Logger log = LoggerFactory.getLogger(RequestHandler.class);
    private static final ServiceProvider serviceProvider = new DefaultServiceProvider();

    public Object handler(RpcRequest rpcRequest) {
        Object result = null;
        try {
            Object service = serviceProvider.getServiceProvider(rpcRequest.getInterfaceName());
            result = this.invokeTargetMethod(rpcRequest, service);
            log.info("Service: {} has invoked method: {} ", (Object)rpcRequest.getInterfaceName(), (Object)rpcRequest.getMethodName());
        }
        catch (RpcException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Error occurred while invoking or sending! info: ", e);
            return e;
        }
        return result;
    }

    private Object invokeTargetMethod(RpcRequest rpcRequest, Object service) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method method = service.getClass().getMethod(rpcRequest.getMethodName(), rpcRequest.getParamTypes());
        return method.invoke(service, rpcRequest.getParameters());
    }
}

