/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.net.netty.server;

import cn.fyupeng.handler.RequestHandler;
import cn.fyupeng.protocol.RpcRequest;
import cn.fyupeng.protocol.RpcResponse;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.ReferenceCountUtil;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServerHandler
extends SimpleChannelInboundHandler<RpcRequest> {
    private static final Logger log = LoggerFactory.getLogger(NettyServerHandler.class);
    private static RequestHandler requestHandler = new RequestHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, RpcRequest msg) throws Exception {
        try {
            if (msg.getHeartBeat().booleanValue()) {
                log.info("receive hearBeatPackage from customer...");
                return;
            }
            log.info("server has received request: {}", (Object)msg);
            Object result = requestHandler.handler(msg);
            if (ctx.channel().isActive() && ctx.channel().isWritable()) {
                String checkCode = "";
                checkCode = result != null ? new String(DigestUtils.md5((byte[])result.toString().getBytes("UTF-8"))) : null;
                RpcResponse rpcResponse = RpcResponse.success((Object)result, (String)msg.getRequestId(), (String)checkCode);
                ChannelFuture channelFuture = ctx.writeAndFlush((Object)rpcResponse);
            } else {
                log.error("channel is not writable");
            }
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.error("error occurred while invoking!,info: ", cause);
        ctx.close();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleState state = ((IdleStateEvent)evt).state();
            if (state == IdleState.READER_IDLE) {
                log.info("Heartbeat packets have not been received for a long time");
                ctx.channel().close();
            }
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }
}

