/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.codec;

import cn.fyupeng.enums.PackageType;
import cn.fyupeng.exception.UnrecognizedException;
import cn.fyupeng.protocol.RpcRequest;
import cn.fyupeng.protocol.RpcResponse;
import cn.fyupeng.serializer.CommonSerializer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonDecoder
extends ReplayingDecoder {
    private static final Logger log = LoggerFactory.getLogger(CommonDecoder.class);
    private static final int MAGIC_NUMBER = -889275714;

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws UnrecognizedException {
        Class<RpcRequest> packageClass;
        int magic = in.readInt();
        if (magic != -889275714) {
            log.error("Unrecognized protocol package: {}", (Object)magic);
            throw new UnrecognizedException("Unrecognized protocol package error");
        }
        int packageCode = in.readInt();
        if (packageCode == PackageType.REQUEST_PACK.getCode()) {
            packageClass = RpcRequest.class;
        } else if (packageCode == PackageType.RESPONSE_PACK.getCode()) {
            packageClass = RpcResponse.class;
        } else {
            log.error("Unrecognized data package: {}", (Object)packageCode);
            throw new UnrecognizedException("Unrecognized data package error");
        }
        int serializerCode = in.readInt();
        CommonSerializer serializer = CommonSerializer.getByCode(serializerCode);
        if (serializer == null) {
            log.error("Unrecognized deserializer : {}", (Object)serializerCode);
            throw new UnrecognizedException("Unrecognized deserializer error");
        }
        int length = in.readInt();
        byte[] bytes = new byte[length];
        in.readBytes(bytes);
        Object obj = serializer.deserialize(bytes, packageClass);
        out.add(obj);
    }
}

