/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.util;

import cn.fyupeng.enums.PackageType;
import cn.fyupeng.exception.UnSupportBodyException;
import cn.fyupeng.protocol.RpcRequest;
import cn.fyupeng.protocol.RpcResponse;
import cn.fyupeng.serializer.CommonSerializer;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectWriter {
    private static final Logger log = LoggerFactory.getLogger(ObjectWriter.class);
    private static int MAGIC_NUMBER = -889275714;

    public static void writeObject(OutputStream outputStream, Object object, CommonSerializer serializer) throws IOException, UnSupportBodyException {
        outputStream.write(ObjectWriter.int2Bytes(MAGIC_NUMBER));
        if (object instanceof RpcRequest) {
            outputStream.write(ObjectWriter.int2Bytes(PackageType.REQUEST_PACK.getCode()));
        } else if (object instanceof RpcResponse) {
            outputStream.write(ObjectWriter.int2Bytes(PackageType.RESPONSE_PACK.getCode()));
        } else {
            log.error("Only request body and response body are supported");
            throw new UnSupportBodyException("Only request body and response body are supported Exception");
        }
        outputStream.write(ObjectWriter.int2Bytes(serializer.getCode()));
        byte[] bytes = serializer.serialize(object);
        outputStream.write(ObjectWriter.int2Bytes(bytes.length));
        outputStream.write(bytes);
        outputStream.flush();
    }

    private static byte[] int2Bytes(int value) {
        byte[] src = new byte[4];
        int mark = 255;
        src[0] = (byte)(value >> 24 & mark);
        src[1] = (byte)(value >> 16 & mark);
        src[2] = (byte)(value >> 8 & mark);
        src[3] = (byte)(value & mark);
        return src;
    }
}

