/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.net.netty.server;

import cn.fyupeng.handler.RequestHandler;
import cn.fyupeng.protocol.RpcRequest;
import cn.fyupeng.protocol.RpcResponse;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.ReferenceCountUtil;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServerHandler
extends SimpleChannelInboundHandler<RpcRequest> {
    private static final Logger log = LoggerFactory.getLogger(NettyServerHandler.class);
    private static RequestHandler requestHandler;
    private static HashSet<String> timeoutRetryRequestIdSet;
    private static HashMap<String, Object> resMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void channelRead0(ChannelHandlerContext ctx, RpcRequest msg) throws Exception {
        block12: {
            try {
                if (msg.getHeartBeat().booleanValue()) {
                    log.trace("receive hearBeatPackage from customer...");
                    return;
                }
                log.info("server has received request: {}", (Object)msg);
                Object result = null;
                if (timeoutRetryRequestIdSet.add(msg.getRequestId())) {
                    result = requestHandler.handler(msg);
                    resMap.put(msg.getRequestId(), result);
                } else {
                    result = resMap.get(msg.getRequestId());
                }
                if (ctx.channel().isActive() && ctx.channel().isWritable()) {
                    String checkCode = "";
                    checkCode = result != null ? new String(DigestUtils.md5(result.toString().getBytes("UTF-8"))) : null;
                    RpcResponse rpcResponse = RpcResponse.success(result, msg.getRequestId(), checkCode);
                    ChannelFuture future = ctx.writeAndFlush(rpcResponse);
                    if (timeoutRetryRequestIdSet.size() < 1000) break block12;
                    NettyServerHandler nettyServerHandler = this;
                    synchronized (nettyServerHandler) {
                        if (timeoutRetryRequestIdSet.size() >= 1000) {
                            timeoutRetryRequestIdSet.clear();
                            resMap.clear();
                            timeoutRetryRequestIdSet.add(msg.getRequestId());
                            resMap.put(msg.getRequestId(), result);
                        }
                        break block12;
                    }
                }
                log.error("channel is not writable");
            }
            finally {
                ReferenceCountUtil.release(msg);
            }
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.error("error occurred while invoking!,info: ", cause);
        ctx.close();
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleState state = ((IdleStateEvent)evt).state();
            if (state == IdleState.READER_IDLE) {
                log.info("Heartbeat packets have not been received for a long time");
                ctx.channel().close();
            }
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    static {
        timeoutRetryRequestIdSet = new HashSet();
        resMap = new HashMap();
        requestHandler = new RequestHandler();
    }
}

