/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.proxy;

import cn.fyupeng.anotion.Reference;
import cn.fyupeng.exception.RetryTimeoutException;
import cn.fyupeng.net.RpcClient;
import cn.fyupeng.net.netty.client.NettyClient;
import cn.fyupeng.net.socket.client.SocketClient;
import cn.fyupeng.protocol.RpcRequest;
import cn.fyupeng.protocol.RpcResponse;
import cn.fyupeng.util.RpcMessageChecker;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcClientProxy
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(RpcClientProxy.class);
    private RpcClient rpcClient;
    private Class<?> pareClazz = null;
    private AtomicInteger sucRes = new AtomicInteger(0);
    private AtomicInteger errRes = new AtomicInteger(0);
    private AtomicInteger timeoutRes = new AtomicInteger(0);

    public RpcClientProxy(RpcClient rpcClient) {
        this.rpcClient = rpcClient;
    }

    public <T> T getProxy(Class<T> clazz, Class<?> pareClazz) {
        this.pareClazz = pareClazz;
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this);
    }

    @Deprecated
    public <T> T getProxy(Class<T> clazz) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        log.info("invoke method:{}#{}", (Object)method.getDeclaringClass().getName(), (Object)method.getName());
        RpcRequest rpcRequest = new RpcRequest.Builder().requestId(UUID.randomUUID().toString()).interfaceName(method.getDeclaringClass().getName()).methodName(method.getName()).parameters(args).paramTypes((Class[])method.getParameterTypes()).heartBeat(Boolean.valueOf(false)).build();
        RpcResponse rpcResponse = null;
        if (this.pareClazz == null) {
            if (this.rpcClient instanceof NettyClient) {
                CompletableFuture completableFuture = (CompletableFuture)this.rpcClient.sendRequest(rpcRequest);
                rpcResponse = (RpcResponse)completableFuture.get();
            }
            if (this.rpcClient instanceof SocketClient) {
                rpcResponse = (RpcResponse)this.rpcClient.sendRequest(rpcRequest);
            }
            RpcMessageChecker.checkAndThrow((RpcRequest)rpcRequest, rpcResponse);
            return rpcResponse.getData();
        }
        if (this.rpcClient instanceof NettyClient) {
            Field[] fields = this.pareClazz.getDeclaredFields();
            long timeout = 0L;
            long asyncTime = 0L;
            int retries = 0;
            boolean useRetry = false;
            for (Field field : fields) {
                if (!field.isAnnotationPresent(Reference.class) || !method.getDeclaringClass().getName().equals(field.getType().getName())) continue;
                retries = field.getAnnotation(Reference.class).retries();
                timeout = field.getAnnotation(Reference.class).timeout();
                asyncTime = field.getAnnotation(Reference.class).asyncTime();
                useRetry = true;
                break;
            }
            if (!useRetry) {
                CompletableFuture completableFuture = (CompletableFuture)this.rpcClient.sendRequest(rpcRequest);
                rpcResponse = (RpcResponse)completableFuture.get();
                RpcMessageChecker.checkAndThrow((RpcRequest)rpcRequest, (RpcResponse)rpcResponse);
            } else {
                for (int i = 0; i <= retries; ++i) {
                    long startTime = System.currentTimeMillis();
                    CompletableFuture completableFuture = (CompletableFuture)this.rpcClient.sendRequest(rpcRequest);
                    try {
                        rpcResponse = (RpcResponse)completableFuture.get(asyncTime, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException e) {
                        this.timeoutRes.incrementAndGet();
                        if (timeout < asyncTime) continue;
                        log.warn("asyncTime [ {} ] should be greater than timeout [ {} ]", (Object)asyncTime, (Object)timeout);
                        continue;
                    }
                    long endTime = System.currentTimeMillis();
                    long handleTime = endTime - startTime;
                    if (handleTime >= timeout) {
                        log.warn("invoke service timeout and retry to invoke [ rms: {}, tms: {} ]", (Object)handleTime, (Object)timeout);
                        log.info("client call timeout counts {}", (Object)this.timeoutRes.incrementAndGet());
                        continue;
                    }
                    if (!RpcMessageChecker.check((RpcRequest)rpcRequest, (RpcResponse)rpcResponse)) continue;
                    log.info("client call success counts {}", (Object)this.sucRes.incrementAndGet());
                    return rpcResponse.getData();
                }
                log.info("client call failed counts {}", (Object)this.errRes.incrementAndGet());
                throw new RetryTimeoutException("\u91cd\u8bd5\u8c03\u7528\u8d85\u65f6\u8d85\u8fc7\u9608\u503c\uff0c\u901a\u9053\u5173\u95ed\uff0c\u8be5\u7ebf\u7a0b\u4e2d\u65ad\uff0c\u5f3a\u5236\u629b\u51fa\u5f02\u5e38\uff01");
            }
        }
        if (this.rpcClient instanceof SocketClient) {
            rpcResponse = (RpcResponse)this.rpcClient.sendRequest(rpcRequest);
            RpcMessageChecker.checkAndThrow((RpcRequest)rpcRequest, (RpcResponse)rpcResponse);
        }
        return rpcResponse.getData();
    }
}

