/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.net.netty.server;

import cn.fyupeng.handler.RequestHandler;
import cn.fyupeng.protocol.RpcRequest;
import cn.fyupeng.protocol.RpcResponse;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServerHandler
extends SimpleChannelInboundHandler<RpcRequest> {
    private static final Logger log = LoggerFactory.getLogger(NettyServerHandler.class);
    private static RequestHandler requestHandler;
    private static HashSet<String> timeoutRetryRequestIdSet;
    private static HashMap<String, Object> resMap;
    private static final EventExecutorGroup group;

    protected void channelRead0(final ChannelHandlerContext ctx, final RpcRequest msg) throws Exception {
        if (msg.getHeartBeat().booleanValue()) {
            log.debug("receive hearBeatPackage from customer...");
            return;
        }
        group.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block14: {
                    try {
                        log.info("server has received request package: {}", (Object)msg);
                        Object result = null;
                        if (timeoutRetryRequestIdSet.add(msg.getRequestId())) {
                            result = requestHandler.handler(msg);
                            resMap.put(msg.getRequestId(), result);
                        } else {
                            result = resMap.get(msg.getRequestId());
                        }
                        if (ctx.channel().isActive() && ctx.channel().isWritable()) {
                            String checkCode = "";
                            if (result != null) {
                                try {
                                    checkCode = new String(DigestUtils.md5((byte[])result.toString().getBytes("UTF-8")));
                                }
                                catch (UnsupportedEncodingException e) {
                                    log.error("binary stream conversion failure: ", (Throwable)e);
                                }
                            } else {
                                checkCode = null;
                            }
                            RpcResponse rpcResponse = RpcResponse.success((Object)result, (String)msg.getRequestId(), (String)checkCode);
                            log.info(String.format("server send back response package {requestId: %s, message: %s, statusCode: %s ]}", rpcResponse.getRequestId(), rpcResponse.getMessage(), rpcResponse.getStatusCode()));
                            ChannelFuture future = ctx.writeAndFlush((Object)rpcResponse);
                            if (timeoutRetryRequestIdSet.size() < 1000) break block14;
                            1 var5_6 = this;
                            synchronized (var5_6) {
                                if (timeoutRetryRequestIdSet.size() >= 1000) {
                                    timeoutRetryRequestIdSet.clear();
                                    resMap.clear();
                                    timeoutRetryRequestIdSet.add(msg.getRequestId());
                                    resMap.put(msg.getRequestId(), result);
                                }
                                break block14;
                            }
                        }
                        log.error("channel is not writable");
                    }
                    finally {
                        ReferenceCountUtil.release((Object)msg);
                    }
                }
            }
        });
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        log.warn("trigger hi-lo channel buffer\uff0cnow channel status:[active {}, writable: {}]", (Object)ctx.channel().isActive(), (Object)ctx.channel().isWritable());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.error("error occurred while invoking!,info: ", cause);
        ctx.close();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleState state = ((IdleStateEvent)evt).state();
            if (state == IdleState.READER_IDLE) {
                log.info("Heartbeat packets have not been received for a long time");
                ctx.channel().close();
            }
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    static {
        timeoutRetryRequestIdSet = new HashSet();
        resMap = new HashMap();
        group = new DefaultEventExecutorGroup(16);
        requestHandler = new RequestHandler();
    }
}

