/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.net.netty.server;

import cn.fyupeng.factory.ThreadPoolFactory;
import cn.fyupeng.handler.RequestHandler;
import cn.fyupeng.protocol.RpcRequest;
import cn.fyupeng.protocol.RpcResponse;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ReferenceCountUtil;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyChannelDispatcher {
    private static final Logger log = LoggerFactory.getLogger(NettyChannelDispatcher.class);
    private static ExecutorService operationExecutorService = ThreadPoolFactory.createDefaultThreadPool((String)"operation-executor-pool");
    private static RequestHandler requestHandler;
    private static HashSet<String> timeoutRetryRequestIdSet;
    private static HashMap<String, Object> resMap;

    public static void init() {
        log.info("netty channel dispatcher initialize successfully!");
    }

    public static void dispatch(final ChannelHandlerContext ctx, final RpcRequest msg) {
        operationExecutorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block14: {
                    try {
                        log.info("server has received request package: {}", (Object)msg);
                        Object result = null;
                        if (timeoutRetryRequestIdSet.add(msg.getRequestId())) {
                            result = requestHandler.handler(msg);
                            resMap.put(msg.getRequestId(), result);
                        } else {
                            result = resMap.get(msg.getRequestId());
                        }
                        if (ctx.channel().isActive() && ctx.channel().isWritable()) {
                            String checkCode = "";
                            if (result != null) {
                                try {
                                    checkCode = new String(DigestUtils.md5((byte[])result.toString().getBytes("UTF-8")));
                                }
                                catch (UnsupportedEncodingException e) {
                                    log.error("binary stream conversion failure: ", (Throwable)e);
                                }
                            } else {
                                checkCode = null;
                            }
                            RpcResponse rpcResponse = RpcResponse.success((Object)result, (String)msg.getRequestId(), (String)checkCode);
                            log.info(String.format("server send back response package {requestId: %s, message: %s, statusCode: %s ]}", rpcResponse.getRequestId(), rpcResponse.getMessage(), rpcResponse.getStatusCode()));
                            ChannelFuture future = ctx.writeAndFlush((Object)rpcResponse);
                            if (timeoutRetryRequestIdSet.size() < 1000) break block14;
                            1 var5_6 = this;
                            synchronized (var5_6) {
                                if (timeoutRetryRequestIdSet.size() >= 1000) {
                                    timeoutRetryRequestIdSet.clear();
                                    resMap.clear();
                                    timeoutRetryRequestIdSet.add(msg.getRequestId());
                                    resMap.put(msg.getRequestId(), result);
                                }
                                break block14;
                            }
                        }
                        log.error("channel is not writable");
                    }
                    finally {
                        ReferenceCountUtil.release((Object)msg);
                    }
                }
            }
        });
    }

    static {
        timeoutRetryRequestIdSet = new HashSet();
        resMap = new HashMap();
        requestHandler = new RequestHandler();
    }
}

