/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.net.netty.client;

import cn.fyupeng.discovery.ServiceDiscovery;
import cn.fyupeng.exception.RpcException;
import cn.fyupeng.factory.SingleFactory;
import cn.fyupeng.loadbalancer.LoadBalancer;
import cn.fyupeng.net.RpcClient;
import cn.fyupeng.net.netty.client.ChannelProvider;
import cn.fyupeng.net.netty.client.UnprocessedRequests;
import cn.fyupeng.protocol.RpcRequest;
import cn.fyupeng.protocol.RpcResponse;
import cn.fyupeng.serializer.CommonSerializer;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyClient
implements RpcClient {
    private static final Logger log = LoggerFactory.getLogger(NettyClient.class);
    private final CommonSerializer serializer;
    private static final EventLoopGroup group = new NioEventLoopGroup();
    private static final Bootstrap bootstrap = new Bootstrap();
    private String hostName;
    private int port;
    private ServiceDiscovery serviceDiscovery;
    private static UnprocessedRequests unprocessedRequests;

    public NettyClient(String hostName, int port, Integer serializerCode) {
        this.hostName = hostName;
        this.port = port;
        this.serializer = CommonSerializer.getByCode((int)serializerCode);
        unprocessedRequests = (UnprocessedRequests)SingleFactory.getInstance(UnprocessedRequests.class);
    }

    public NettyClient(LoadBalancer loadBalancer, Integer serializerCode) {
        this.serviceDiscovery = ServiceLoader.load(ServiceDiscovery.class).iterator().next();
        this.serviceDiscovery.setLoadBalancer(loadBalancer);
        this.serializer = CommonSerializer.getByCode((int)serializerCode);
        unprocessedRequests = (UnprocessedRequests)SingleFactory.getInstance(UnprocessedRequests.class);
    }

    @Override
    public CompletableFuture<RpcResponse> sendRequest(final RpcRequest rpcRequest) throws RpcException {
        Channel channel;
        final CompletableFuture<RpcResponse> resultFuture = new CompletableFuture<RpcResponse>();
        if (this.serviceDiscovery != null) {
            String serviceName = rpcRequest.getInterfaceName();
            InetSocketAddress address = null;
            String group = rpcRequest.getGroup();
            address = group != null ? this.serviceDiscovery.lookupService(serviceName, group) : this.serviceDiscovery.lookupService(serviceName);
            this.hostName = address.getHostName();
            this.port = address.getPort();
        }
        if (!(channel = ChannelProvider.get(new InetSocketAddress(this.hostName, this.port), this.serializer)).isActive()) {
            group.shutdownGracefully();
            return null;
        }
        log.info("customer has connected to server successfully {}:{}", (Object)this.hostName, (Object)this.port);
        unprocessedRequests.put(rpcRequest.getRequestId(), resultFuture);
        channel.writeAndFlush((Object)rpcRequest).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    log.info(String.format("customer sent message: %s", rpcRequest.toString()));
                } else {
                    future.channel().close();
                    resultFuture.completeExceptionally(future.cause());
                    log.error("Error occurred while sending message: {}", future.cause());
                }
            }
        });
        return resultFuture;
    }

    static {
        ((Bootstrap)bootstrap.group(group)).channel(NioSocketChannel.class);
    }
}

