/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.net.netty.server;

import cn.fyupeng.handler.RequestHandler;
import cn.fyupeng.idworker.utils.JRedisHelper;
import cn.fyupeng.idworker.utils.LRedisHelper;
import cn.fyupeng.protocol.RpcRequest;
import cn.fyupeng.protocol.RpcResponse;
import cn.fyupeng.serializer.CommonSerializer;
import cn.fyupeng.util.JsonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.ReferenceCountUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServerHandler
extends SimpleChannelInboundHandler<RpcRequest> {
    private static final Logger log;
    private static RequestHandler requestHandler;
    private static HashSet<String> timeoutRetryRequestIdSet;
    private static String redisServerWay;
    private static String redisServerAsync;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, RpcRequest msg) throws Exception {
        try {
            CommonSerializer serializer;
            if (msg.getHeartBeat().booleanValue()) {
                log.trace("receive hearBeatPackage from customer...");
                return;
            }
            log.info("server has received request: {}", (Object)msg);
            Object result = null;
            if ("jedis".equals(redisServerWay) || "default".equals(redisServerWay) || StringUtils.isBlank((String)redisServerWay)) {
                if (!JRedisHelper.existsRetryResult((String)msg.getRequestId())) {
                    log.info("requestId[{}] does not exist, store the result in the distributed cache", (Object)msg.getRequestId());
                    result = requestHandler.handler(msg);
                    JRedisHelper.setRetryRequestResult((String)msg.getRequestId(), (String)JsonUtils.objectToJson((Object)result));
                } else {
                    result = JRedisHelper.getForRetryRequestId((String)msg.getRequestId());
                    result = JsonUtils.jsonToPojo((String)result, (Class)msg.getReturnType());
                    log.info("Previous results:{} ", result);
                    log.info(" >>> Capture the timeout packet and call the previous result successfully <<< ");
                }
            } else if (LRedisHelper.existsRetryResult((String)msg.getRequestId()) == 0L) {
                log.info("requestId[{}] does not exist, store the result in the distributed cache", (Object)msg.getRequestId());
                result = requestHandler.handler(msg);
                serializer = CommonSerializer.getByCode((int)CommonSerializer.KRYO_SERIALIZER);
                if ("true".equals(redisServerAsync)) {
                    LRedisHelper.asyncSetRetryRequestResult((String)msg.getRequestId(), (byte[])serializer.serialize(result));
                } else {
                    LRedisHelper.syncSetRetryRequestResult((String)msg.getRequestId(), (byte[])serializer.serialize(result));
                }
            } else {
                serializer = CommonSerializer.getByCode((int)CommonSerializer.KRYO_SERIALIZER);
                result = LRedisHelper.getForRetryRequestId((String)msg.getRequestId());
                result = serializer.deserialize((byte[])result, msg.getReturnType());
                log.info("Previous results:{} ", result);
                log.info(" >>> Capture the timeout packet and call the previous result successfully <<< ");
            }
            if (ctx.channel().isActive() && ctx.channel().isWritable()) {
                String checkCode = "";
                checkCode = result != null ? new String(DigestUtils.md5((byte[])result.toString().getBytes("UTF-8"))) : null;
                RpcResponse rpcResponse = RpcResponse.success((Object)result, (String)msg.getRequestId(), (String)checkCode);
                ChannelFuture channelFuture = ctx.writeAndFlush((Object)rpcResponse);
            } else {
                log.error("channel is not writable");
            }
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.error("error occurred while invoking! info: ", cause);
        ctx.close();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleState state = ((IdleStateEvent)evt).state();
            if (state == IdleState.READER_IDLE) {
                log.info("Heartbeat packets have not been received for a long time");
                ctx.channel().close();
            }
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    static {
        block29: {
            log = LoggerFactory.getLogger(NettyServerHandler.class);
            timeoutRetryRequestIdSet = new HashSet();
            redisServerWay = "";
            redisServerAsync = "";
            String currentWorkPath = System.getProperty("user.dir");
            PropertyResourceBundle configResource = null;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(currentWorkPath + "/config/resource.properties"));){
                configResource = new PropertyResourceBundle(bufferedReader);
                redisServerWay = configResource.getString("cn.fyupeng.redis.server-way");
                if ("jedis".equals(redisServerWay) || "default".equals(redisServerWay) || StringUtils.isBlank((String)redisServerWay)) {
                    log.info("find redis client way attribute is jedis");
                    break block29;
                }
                if ("lettuce".equals(redisServerWay)) {
                    log.info("find redis client way attribute is lettuce");
                    try {
                        redisServerAsync = configResource.getString("cn.fyupeng.redis.server-async");
                        if ("false".equals(redisServerAsync) || "default".equals(redisServerAsync) || StringUtils.isBlank((String)redisServerAsync)) {
                            log.info("find redis server async attribute is false");
                            break block29;
                        }
                        if ("true".equals(redisServerAsync)) {
                            log.info("find redis server async attribute is lettuce");
                            break block29;
                        }
                        throw new RuntimeException("redis server async attribute is illegal!");
                    }
                    catch (MissingResourceException redisServerAsyncException) {
                        log.warn("redis server async attribute is missing");
                        log.info("use default redis server default async: false");
                        redisServerAsync = "false";
                    }
                    break block29;
                }
                throw new RuntimeException("redis server async attribute is illegal!");
            }
            catch (MissingResourceException redisServerWayException) {
                log.warn("redis client way attribute is missing");
                log.info("use default redis client default way: jedis");
                redisServerWay = "jedis";
            }
            catch (IOException ioException) {
                block30: {
                    log.info("not found resource from resource path: {}", (Object)(currentWorkPath + "/config/resource.properties"));
                    try {
                        ResourceBundle resource = ResourceBundle.getBundle("resource");
                        redisServerWay = resource.getString("cn.fyupeng.redis.server-way");
                        if ("jedis".equals(redisServerWay) || "default".equals(redisServerWay) || StringUtils.isBlank((String)redisServerWay)) {
                            log.info("find redis server way attribute is jedis");
                            break block30;
                        }
                        if ("lettuce".equals(redisServerWay)) {
                            log.info("find redis server way attribute is lettuce");
                            try {
                                redisServerAsync = resource.getString("cn.fyupeng.redis.server-async");
                                if ("false".equals(redisServerAsync) || "default".equals(redisServerAsync) || StringUtils.isBlank((String)redisServerAsync)) {
                                    log.info("find redis server async attribute is false");
                                    break block30;
                                }
                                if ("true".equals(redisServerAsync)) {
                                    log.info("find redis server async attribute is lettuce");
                                    break block30;
                                }
                                throw new RuntimeException("redis server async attribute is illegal!");
                            }
                            catch (MissingResourceException redisServerAsyncException) {
                                log.warn("redis server async attribute is missing");
                                log.info("use default redis server default async: false");
                                redisServerAsync = "false";
                            }
                            break block30;
                        }
                        throw new RuntimeException("redis client way attribute is illegal!");
                    }
                    catch (MissingResourceException resourceException) {
                        log.info("not found resource from resource path: {}", (Object)"resource.properties");
                        log.info("use default redis server way: jedis");
                        redisServerWay = "jedis";
                    }
                }
                log.info("read resource from resource path: {}", (Object)"resource.properties");
            }
        }
        requestHandler = new RequestHandler();
    }
}

