/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.serializer;

import cn.fyupeng.enums.SerializerCode;
import cn.fyupeng.protocol.RpcRequest;
import cn.fyupeng.serializer.CommonSerializer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSerializer
implements CommonSerializer {
    private static final Logger log = LoggerFactory.getLogger(JsonSerializer.class);
    private ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public byte[] serialize(Object obj) {
        byte[] data = null;
        try {
            data = this.objectMapper.writeValueAsBytes(obj);
        }
        catch (JsonProcessingException e) {
            log.error("Error occurred while serializing, info: {}", (Object)e.getMessage());
        }
        return data;
    }

    @Override
    public Object deserialize(byte[] data, Class<?> clazz) {
        if (data == null) {
            return null;
        }
        Object obj = null;
        try {
            obj = this.objectMapper.readValue(data, clazz);
            if (obj instanceof RpcRequest) {
                obj = this.validateAndHandlerRequest(obj);
            }
        }
        catch (IOException e) {
            log.error("Error occurred while deserializing, info: ", e);
        }
        return obj;
    }

    private Object validateAndHandlerRequest(Object obj) throws IOException {
        RpcRequest rpcRequest = (RpcRequest)obj;
        System.out.println("validateAndHandlerRequest" + rpcRequest);
        for (int i = 0; i < rpcRequest.getParamTypes().length; ++i) {
            Class<?> clazz = rpcRequest.getParamTypes()[i];
            if (clazz.isAssignableFrom(rpcRequest.getParameters()[i].getClass())) continue;
            byte[] bytes = this.objectMapper.writeValueAsBytes(rpcRequest.getParameters()[i]);
            rpcRequest.getParameters()[i] = this.objectMapper.readValue(bytes, clazz);
        }
        return rpcRequest;
    }

    @Override
    public int getCode() {
        return SerializerCode.valueOf("JSON").getCode();
    }
}

