/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client;

import io.prometheus.client.Striped64;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class DoubleAdder
extends Striped64
implements Serializable {
    private static final long serialVersionUID = 7249069246863182397L;

    @Override
    final long fn(long v, long x) {
        return Double.doubleToRawLongBits(Double.longBitsToDouble(v) + Double.longBitsToDouble(x));
    }

    public void add(double x) {
        long b;
        Striped64.Cell[] as = this.cells;
        if (this.cells != null || !this.casBase(b = this.base, Double.doubleToRawLongBits(Double.longBitsToDouble(b) + x))) {
            long v;
            Striped64.Cell a;
            int n;
            boolean uncontended = true;
            int[] hc = (int[])threadHashCode.get();
            if (hc == null || as == null || (n = as.length) < 1 || (a = as[n - 1 & hc[0]]) == null || !(uncontended = a.cas(v = a.value, Double.doubleToRawLongBits(Double.longBitsToDouble(v) + x)))) {
                this.retryUpdate(Double.doubleToRawLongBits(x), hc, uncontended);
            }
        }
    }

    public double sum() {
        Striped64.Cell[] as = this.cells;
        double sum = Double.longBitsToDouble(this.base);
        if (as != null) {
            for (Striped64.Cell a : as) {
                if (a == null) continue;
                sum += Double.longBitsToDouble(a.value);
            }
        }
        return sum;
    }

    public void reset() {
        this.internalReset(0L);
    }

    public double sumThenReset() {
        Striped64.Cell[] as = this.cells;
        double sum = Double.longBitsToDouble(this.base);
        this.base = 0L;
        if (as != null) {
            for (Striped64.Cell a : as) {
                if (a == null) continue;
                long v = a.value;
                a.value = 0L;
                sum += Double.longBitsToDouble(v);
            }
        }
        return sum;
    }

    public String toString() {
        return Double.toString(this.sum());
    }

    @Override
    public double doubleValue() {
        return this.sum();
    }

    @Override
    public long longValue() {
        return (long)this.sum();
    }

    @Override
    public int intValue() {
        return (int)this.sum();
    }

    @Override
    public float floatValue() {
        return (float)this.sum();
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeDouble(this.sum());
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.busy = 0;
        this.cells = null;
        this.base = Double.doubleToRawLongBits(s2.readDouble());
    }
}

