/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.idworker.utils;

import com.alibaba.nacos.common.utils.StringUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class JRedisHelper {
    private static final Logger log = LoggerFactory.getLogger(JRedisHelper.class);
    private static Object lock = new Object();
    private static final String workerIds = "worker-ids";
    private static final String workerIdsSet = "worker-ids-set";
    private static final String retryReqIds = "retry-req-ids";
    private static Jedis jedis;
    private static final String DEFAULT_ADDRESS = "127.0.0.1:6379";

    public static boolean exists(String key) {
        return jedis.exists(key);
    }

    public static void set(String key, String value) {
        jedis.set(key, value);
    }

    public static String get(String key) {
        return jedis.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existsWorkerId(String hostName) {
        Object object = lock;
        synchronized (object) {
            return jedis.exists("worker-ids:" + hostName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getForHostName(String hostName) {
        Object object = lock;
        synchronized (object) {
            log.trace("getForHostName key[{}]", (Object)hostName);
            return jedis.get("worker-ids:" + hostName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setWorkerId(String hostName, long workerId) {
        Object object = lock;
        synchronized (object) {
            log.trace("setWorkerId key[{}]", (Object)hostName);
            jedis.set("worker-ids:" + hostName, String.valueOf(workerId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remWorkerId(String hostName) {
        Object object = lock;
        synchronized (object) {
            log.trace("remWorkerId key[{}]", (Object)hostName);
            String workerId = JRedisHelper.getForHostName(hostName);
            jedis.del("worker-ids:" + hostName);
            if (workerId != null) {
                jedis.srem(workerIdsSet, workerId);
            }
        }
    }

    public static boolean existsWorkerIdSet(long workerId) {
        return jedis.sismember(workerIdsSet, String.valueOf(workerId));
    }

    public static void setWorkerIdSet(long workerId) {
        jedis.sadd(workerIdsSet, String.valueOf(workerId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existsRetryResult(String retryRequestId) {
        Object object = lock;
        synchronized (object) {
            return jedis.exists("retry-req-ids:" + retryRequestId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getForRetryRequestId(String retryRequestId) {
        Object object = lock;
        synchronized (object) {
            log.trace("getForRetryRequestId key[{}]", (Object)retryRequestId);
            return jedis.get("retry-req-ids:" + retryRequestId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRetryRequestResult(String retryRequestId, String result) {
        Object object = lock;
        synchronized (object) {
            log.trace("setRetryRequestResult key[{}]- value[{}]", (Object)retryRequestId, (Object)result);
            jedis.set("retry-req-ids:" + retryRequestId, result, "NX", "EX", 60);
        }
    }

    public static void main(String[] args) {
    }

    static {
        String currentWorkPath = System.getProperty("user.dir");
        Object is = null;
        ResourceBundle configResource = null;
        String redisAuth = "";
        String redisPwd = "";
        String redisAddr = "";
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(currentWorkPath + "/config/resource.properties"));){
            String[] hostAndPort;
            configResource = new PropertyResourceBundle(bufferedReader);
            redisAuth = configResource.getString("cn.fyupeng.redis.server-auth");
            if ("false".equals(redisAuth) || "default".equals(redisAuth) || StringUtils.isBlank(redisAuth)) {
                log.info("--- no redis auth ---");
                try {
                    redisAddr = configResource.getString("cn.fyupeng.redis.server-addr");
                    hostAndPort = redisAddr.split(":");
                    jedis = new Jedis(hostAndPort[0], Integer.parseInt(hostAndPort[1]));
                }
                catch (MissingResourceException redisServerAddressException) {
                    String[] hostAndPort2 = DEFAULT_ADDRESS.split(":");
                    jedis = new Jedis(hostAndPort2[0], Integer.parseInt(hostAndPort2[1]));
                    log.warn("redis server address attribute is missing");
                    log.info("use default redis server address : 127.0.0.1:6379");
                }
            } else {
                if ("true".equals(redisAuth)) {
                    log.info("redis auth attribute is true and start with auth");
                    try {
                        redisAddr = configResource.getString("cn.fyupeng.redis.server-addr");
                    }
                    catch (MissingResourceException redisServerAddressException) {
                        log.info("redis server address property attribute is missing: {}", (Object)redisServerAddressException.getMessage());
                        log.info("use default redis server address : 127.0.0.1:6379");
                        String[] hostAndPort3 = DEFAULT_ADDRESS.split(":");
                        jedis = new Jedis(hostAndPort3[0], Integer.parseInt(hostAndPort3[1]));
                    }
                    try {
                        redisPwd = configResource.getString("cn.fyupeng.redis.server-pwd");
                        hostAndPort = redisAddr.split(":");
                        jedis = new Jedis(hostAndPort[0], Integer.parseInt(hostAndPort[1]));
                        jedis.auth(redisPwd);
                    }
                    catch (MissingResourceException redisPasswordException) {
                        log.error("redis password attribute is missing: ", redisPasswordException);
                        throw new RuntimeException("redis password attribute is missing!");
                    }
                }
                throw new RuntimeException("redis auth attribute is illegal!");
            }
            log.info("read resource from resource path: {}", (Object)(currentWorkPath + "/config/resource.properties"));
        }
        catch (MissingResourceException redisAuthException) {
            log.warn("redis auth attribute is missing and start with no auth");
            try {
                String redisAddress = configResource.getString("cn.fyupeng.redis.server-addr");
                redisAddr = StringUtils.isBlank(redisAddress) ? DEFAULT_ADDRESS : redisAddress;
                String[] hostAndPort = redisAddr.split(":");
                jedis = new Jedis(hostAndPort[0], Integer.parseInt(hostAndPort[1]));
            }
            catch (MissingResourceException redisServerAddressException) {
                String[] hostAndPort = DEFAULT_ADDRESS.split(":");
                jedis = new Jedis(hostAndPort[0], Integer.parseInt(hostAndPort[1]));
                log.warn("redis server address attribute is missing");
                log.info("use default redis server address : 127.0.0.1:6379");
            }
        }
        catch (IOException ioException) {
            block39: {
                log.info("not found resource from resource path: {}", (Object)(currentWorkPath + "/config/resource.properties"));
                try {
                    ResourceBundle resource = ResourceBundle.getBundle("resource");
                    try {
                        redisAuth = resource.getString("cn.fyupeng.redis.server-auth");
                        if ("false".equals(redisAuth) || "default".equals(redisAuth) || StringUtils.isBlank(redisAuth)) {
                            log.info("--- no redis auth ---");
                            try {
                                redisAddr = resource.getString("cn.fyupeng.redis.server-addr");
                                String[] hostAndPort = redisAddr.split(":");
                                jedis = new Jedis(hostAndPort[0], Integer.parseInt(hostAndPort[1]));
                            }
                            catch (MissingResourceException redisServerAddressException) {
                                String[] hostAndPort = DEFAULT_ADDRESS.split(":");
                                jedis = new Jedis(hostAndPort[0], Integer.parseInt(hostAndPort[1]));
                                log.warn("redis server address attribute is missing");
                                log.info("use default redis server address : 127.0.0.1:6379");
                            }
                            break block39;
                        }
                        if ("true".equals(redisAuth)) {
                            log.info("redis auth attribute is true and start with auth");
                            try {
                                redisAddr = resource.getString("cn.fyupeng.redis.server-addr");
                            }
                            catch (MissingResourceException redisServerAddressException) {
                                log.info("redis server address property attribute is missing: {}", (Object)redisServerAddressException.getMessage());
                                log.info("use default redis server address : 127.0.0.1:6379");
                                String[] hostAndPort = DEFAULT_ADDRESS.split(":");
                                jedis = new Jedis(hostAndPort[0], Integer.parseInt(hostAndPort[1]));
                            }
                            try {
                                redisPwd = resource.getString("cn.fyupeng.redis.server-pwd");
                                String[] hostAndPort = redisAddr.split(":");
                                jedis = new Jedis(hostAndPort[0], Integer.parseInt(hostAndPort[1]));
                                jedis.auth(redisPwd);
                                break block39;
                            }
                            catch (MissingResourceException redisPasswordException) {
                                log.error("redis password attribute is missing: ", redisPasswordException);
                                throw new RuntimeException("redis password attribute is missing!");
                            }
                        }
                        throw new RuntimeException("redis auth attribute is illegal!");
                    }
                    catch (MissingResourceException clusterUseException) {
                        log.info("redis auth attribute is missing and start with no auth");
                        redisAddr = resource.getString("cn.fyupeng.redis.server-addr");
                        String[] hostAndPort = redisAddr.split(":");
                        jedis = new Jedis(hostAndPort[0], Integer.parseInt(hostAndPort[1]));
                    }
                }
                catch (MissingResourceException resourceException) {
                    log.info("not found resource from resource path: {}", (Object)"resource.properties");
                    log.info("Connect to default address {}", (Object)DEFAULT_ADDRESS);
                    String[] hostAndPort = DEFAULT_ADDRESS.split(":");
                    jedis = new Jedis(hostAndPort[0], Integer.parseInt(hostAndPort[1]));
                }
            }
            log.info("read resource from resource path: {}", (Object)"resource.properties");
        }
    }
}

