/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.net.netty.client;

import cn.fyupeng.protocol.RpcResponse;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class UnprocessedRequests {
    private static ConcurrentMap<String, CompletableFuture<RpcResponse>> unprocessedResponseFutures = new ConcurrentHashMap<String, CompletableFuture<RpcResponse>>();
    private static ConcurrentMap<String, Integer> unprocessedResponseReentrantCounts = new ConcurrentHashMap<String, Integer>();

    public void put(String requestId, CompletableFuture<RpcResponse> future) {
        Integer reentrantCount = (Integer)unprocessedResponseReentrantCounts.get(requestId);
        if (unprocessedResponseFutures.containsKey(requestId)) {
            unprocessedResponseReentrantCounts.put(requestId, reentrantCount + 1);
            return;
        }
        unprocessedResponseFutures.put(requestId, future);
        unprocessedResponseReentrantCounts.put(requestId, 0);
    }

    public void remove(String requestId) {
        Integer reentrantCount = (Integer)unprocessedResponseReentrantCounts.get(requestId);
        if (unprocessedResponseFutures.containsKey(requestId) && reentrantCount > 0) {
            unprocessedResponseReentrantCounts.put(requestId, reentrantCount - 1);
            return;
        }
        unprocessedResponseFutures.remove(requestId);
    }

    public void complete(RpcResponse rpcResponse) {
        String requestId = rpcResponse.getRequestId();
        Integer reentrantCount = (Integer)unprocessedResponseReentrantCounts.get(requestId);
        if (unprocessedResponseFutures.containsKey(requestId) && reentrantCount > 0) {
            unprocessedResponseReentrantCounts.put(requestId, reentrantCount - 1);
            CompletableFuture completableFuture = (CompletableFuture)unprocessedResponseFutures.get(requestId);
            completableFuture.complete(rpcResponse);
            return;
        }
        CompletableFuture completableFuture = (CompletableFuture)unprocessedResponseFutures.remove(rpcResponse.getRequestId());
        completableFuture.complete(rpcResponse);
    }
}

