/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.net.netty.client;

import cn.fyupeng.codec.CommonDecoder;
import cn.fyupeng.codec.CommonEncoder;
import cn.fyupeng.exception.ConnectFailedException;
import cn.fyupeng.exception.RpcException;
import cn.fyupeng.net.netty.client.NettyClientHandler;
import cn.fyupeng.serializer.CommonSerializer;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelProvider {
    private static final Logger log = LoggerFactory.getLogger(ChannelProvider.class);
    private static EventLoopGroup group;
    private static Bootstrap bootstrap;
    private static Map<String, Channel> channels;

    public static Channel get(InetSocketAddress address, final CommonSerializer serializer) throws RpcException {
        Channel channel;
        String key = address.toString() + serializer.getCode();
        if (channels.containsKey(key)) {
            channel = channels.get(key);
            if (channel != null && channel.isActive()) {
                return channel;
            }
            channels.remove(key);
        }
        bootstrap.handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new IdleStateHandler(3L, 5L, 7L, TimeUnit.SECONDS)).addLast(new CommonDecoder()).addLast(new CommonEncoder(serializer)).addLast(new NettyClientHandler());
            }
        });
        channel = null;
        try {
            channel = ChannelProvider.connect(bootstrap, address);
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("error occurred while customer connecting server: {}", (Object)e.getMessage());
            throw new ConnectFailedException("error occurred while customer connecting server Exception");
        }
        channels.put(key, channel);
        return channel;
    }

    private static Channel connect(Bootstrap bootstrap, InetSocketAddress address) throws ExecutionException, InterruptedException {
        final CompletableFuture completableFuture = new CompletableFuture();
        ChannelFuture channelFuture = bootstrap.connect(address);
        channelFuture.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    throw new IllegalStateException();
                }
                completableFuture.complete(future.channel());
            }
        });
        return (Channel)completableFuture.get();
    }

    private static Bootstrap initBootstrap() {
        group = new NioEventLoopGroup();
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(group)).channel(NioSocketChannel.class)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 5000)).option(ChannelOption.SO_KEEPALIVE, true)).option(ChannelOption.TCP_NODELAY, true);
        return bootstrap;
    }

    static {
        bootstrap = ChannelProvider.initBootstrap();
        channels = new ConcurrentHashMap<String, Channel>();
    }
}

