/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.internal;

import java.util.Collection;
import java.util.Iterator;

public class LettuceStrings {
    private LettuceStrings() {
    }

    public static boolean isEmpty(String cs) {
        return cs == null || cs.isEmpty();
    }

    public static boolean isEmpty(CharSequence cs) {
        if (cs instanceof String) {
            return LettuceStrings.isEmpty((String)cs);
        }
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(String cs) {
        return !LettuceStrings.isEmpty(cs);
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !LettuceStrings.isEmpty(cs);
    }

    public static String string(double n) {
        if (Double.isInfinite(n)) {
            return n > 0.0 ? "+inf" : "-inf";
        }
        return Double.toString(n);
    }

    public static double toDouble(String s2) {
        if ("+inf".equals(s2) || "inf".equals(s2)) {
            return Double.POSITIVE_INFINITY;
        }
        if ("-inf".equals(s2)) {
            return Double.NEGATIVE_INFINITY;
        }
        if ("-nan".equals(s2) || "nan".equals(s2) || "+nan".equals(s2)) {
            return Double.NaN;
        }
        return Double.parseDouble(s2);
    }

    public static String arrayToDelimitedString(Object[] arr, String delim) {
        if (arr == null || arr.length == 0) {
            return "";
        }
        if (arr.length == 1) {
            return "" + arr[0];
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(delim);
            }
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    public static String collectionToDelimitedString(Collection<?> coll, String delim, String prefix, String suffix) {
        if (coll == null || coll.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<?> it = coll.iterator();
        while (it.hasNext()) {
            sb.append(prefix).append(it.next()).append(suffix);
            if (!it.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }
}

