/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.net.netty.server;

import cn.fyupeng.codec.CommonDecoder;
import cn.fyupeng.codec.CommonEncoder;
import cn.fyupeng.exception.RpcException;
import cn.fyupeng.hook.ShutdownHook;
import cn.fyupeng.idworker.utils.LRedisHelper;
import cn.fyupeng.net.AbstractRpcServer;
import cn.fyupeng.net.netty.server.NettyChannelDispatcher;
import cn.fyupeng.net.netty.server.NettyServerHandler;
import cn.fyupeng.provider.ServiceProvider;
import cn.fyupeng.registry.ServiceRegistry;
import cn.fyupeng.serializer.CommonSerializer;
import cn.fyupeng.util.IpUtils;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.timeout.IdleStateHandler;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServer
extends AbstractRpcServer {
    private static final Logger log = LoggerFactory.getLogger(NettyServer.class);
    private final CommonSerializer serializer;
    private static String redisServerWay = "";

    public NettyServer(String hostName, int port, Integer serializerCode) throws RpcException {
        this.hostName = hostName.equals("localhost") || hostName.equals("127.0.0.1") ? IpUtils.getPubIpAddr() : hostName;
        log.info("start with host: {}, port: {}", (Object)this.hostName, (Object)port);
        this.port = port;
        this.serviceRegistry = ServiceLoader.load(ServiceRegistry.class).iterator().next();
        this.serviceProvider = ServiceLoader.load(ServiceProvider.class).iterator().next();
        this.serializer = CommonSerializer.getByCode(serializerCode);
        this.scanServices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        ShutdownHook.getShutdownHook().addClearAllHook();
        NioEventLoopGroup bossGroup = new NioEventLoopGroup();
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap serverBootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)serverBootstrap.group(bossGroup, workerGroup).channel(NioServerSocketChannel.class)).handler(new LoggingHandler(LogLevel.INFO))).option(ChannelOption.SO_BACKLOG, 256)).option(ChannelOption.SO_KEEPALIVE, true)).childOption(ChannelOption.TCP_NODELAY, true).childHandler(new ChannelInitializer<SocketChannel>(){

                @Override
                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast(new IdleStateHandler(30L, 0L, 0L, TimeUnit.SECONDS));
                    pipeline.addLast(new CommonEncoder(NettyServer.this.serializer));
                    pipeline.addLast(new CommonDecoder());
                    pipeline.addLast(new NettyServerHandler());
                }
            });
            ChannelFuture future = serverBootstrap.bind(this.port).sync();
            future.channel().closeFuture().sync();
        }
        catch (Exception e) {
            log.error("Error occurred while starting server! {}", e);
            e.printStackTrace();
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }

    static {
        String currentWorkPath = System.getProperty("user.dir");
        PropertyResourceBundle configResource = null;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(currentWorkPath + "/config/resource.properties"));){
            configResource = new PropertyResourceBundle(bufferedReader);
            redisServerWay = configResource.getString("cn.fyupeng.redis.server-way");
            if ("lettuce".equals(redisServerWay)) {
                LRedisHelper.preLoad();
            }
        }
        catch (MissingResourceException redisServerWayException) {
            log.warn("redis client way attribute is missing");
            log.info("use default redis client default way: jedis");
            redisServerWay = "jedis";
        }
        catch (IOException ioException) {
            log.info("not found resource from resource path: {}", (Object)(currentWorkPath + "/config/resource.properties"));
            try {
                ResourceBundle resource = ResourceBundle.getBundle("resource");
                redisServerWay = resource.getString("cn.fyupeng.redis.server-way");
                if ("lettuce".equals(redisServerWay)) {
                    LRedisHelper.preLoad();
                }
            }
            catch (MissingResourceException resourceException) {
                log.info("not found resource from resource path: {}", (Object)"resource.properties");
                log.info("use default redis client way: jedis");
                redisServerWay = "jedis";
            }
            log.info("read resource from resource path: {}", (Object)"resource.properties");
        }
        NettyChannelDispatcher.init();
    }
}

