/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.net.socket.client;

import cn.fyupeng.exception.RpcException;
import cn.fyupeng.exception.SerializerNotSetException;
import cn.fyupeng.net.RpcClient;
import cn.fyupeng.protocol.RpcRequest;
import cn.fyupeng.protocol.RpcResponse;
import cn.fyupeng.serializer.CommonSerializer;
import cn.fyupeng.util.ObjectReader;
import cn.fyupeng.util.ObjectWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketClient
implements RpcClient {
    private static final Logger log = LoggerFactory.getLogger(SocketClient.class);
    private String hostName;
    private int port;
    private final CommonSerializer serializer;

    public SocketClient(String hostName, int port, Integer serializerCode) {
        this.hostName = hostName;
        this.port = port;
        this.serializer = CommonSerializer.getByCode((int)serializerCode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object sendRequest(RpcRequest rpcRequest) throws RpcException {
        if (this.serializer == null) {
            log.error("Serializer not set");
            throw new SerializerNotSetException("Serializer not set Exception");
        }
        try (Socket socket = new Socket(this.hostName, this.port);){
            RpcResponse rpcResponse2;
            ObjectOutputStream oos = new ObjectOutputStream(socket.getOutputStream());
            ObjectInputStream ois = new ObjectInputStream(socket.getInputStream());
            ObjectWriter.writeObject(oos, rpcRequest, this.serializer);
            Object obj = ObjectReader.readObject(ois);
            RpcResponse rpcResponse = rpcResponse2 = (RpcResponse)obj;
            return rpcResponse;
        }
        catch (IOException e) {
            log.error("Error occurred while invoking badly,info: {}", (Throwable)e);
            return null;
        }
    }
}

