/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.net.socket.server;

import cn.fyupeng.exception.RpcException;
import cn.fyupeng.factory.ThreadPoolFactory;
import cn.fyupeng.handler.RequestHandler;
import cn.fyupeng.hook.ServerShutdownHook;
import cn.fyupeng.net.AbstractRpcServer;
import cn.fyupeng.net.socket.server.SocketRequestHandlerThread;
import cn.fyupeng.provider.DefaultServiceProvider;
import cn.fyupeng.registry.NacosServiceRegistry;
import cn.fyupeng.serializer.CommonSerializer;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketServer
extends AbstractRpcServer {
    private static final Logger log = LoggerFactory.getLogger(SocketServer.class);
    private final ExecutorService threadPool;
    private final CommonSerializer serializer;
    private final RequestHandler requestHandler = new RequestHandler();

    public SocketServer(String host, int port, Integer serializerCode) throws RpcException {
        this.hostName = host;
        this.port = port;
        this.threadPool = ThreadPoolFactory.createDefaultThreadPool((String)"socket-rpc-server");
        this.serviceRegistry = new NacosServiceRegistry();
        this.serviceProvider = new DefaultServiceProvider();
        this.serializer = CommonSerializer.getByCode((int)serializerCode);
        this.scanServices();
    }

    @Override
    public void start() {
        try (ServerSocket serverSocket = new ServerSocket(this.port);){
            Socket socket;
            log.info("Server is running...");
            ServerShutdownHook.getShutdownHook().addClearAllHook();
            while ((socket = serverSocket.accept()) != null) {
                log.info("customer has connected successfully! ip = " + socket.getInetAddress());
                this.threadPool.execute(new SocketRequestHandlerThread(socket, this.requestHandler, this.serializer));
            }
            this.threadPool.shutdown();
        }
        catch (IOException e) {
            log.error("Exception throws when connecting, info: {}", (Throwable)e);
        }
    }
}

