/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.config;

import cn.fyupeng.config.Configuration;
import cn.fyupeng.enums.LoadBalancerCode;
import cn.fyupeng.exception.RpcException;
import cn.fyupeng.loadbalancer.LoadBalancer;
import cn.fyupeng.util.IpUtils;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingFactory;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.common.utils.StringUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosConfiguration
implements Configuration {
    private static final Logger log = LoggerFactory.getLogger(NacosConfiguration.class);
    private static final Set<String> serviceNames = new HashSet<String>();
    private static LoadBalancer loadBalancer;
    private static String SERVER_ADDR;
    private static NamingService namingService;
    private static InetSocketAddress inetSocketAddress;
    private static String[] nodes;

    private static NamingService getNacosNamingService(String newAddress) {
        try {
            return NamingFactory.createNamingService(newAddress != null ? newAddress : SERVER_ADDR);
        }
        catch (NacosException e) {
            log.error("error occurred when connecting to nacos server: ", e);
            return null;
        }
    }

    public static List<Instance> getAllInstance(String serviceName) throws RpcException, NacosException {
        if (nodes.length != 1 && namingService.getServerStatus() == "DOWN") {
            String node = loadBalancer.selectNode(nodes);
            log.info("disaster recovery switch occurred in registration center[{}]", (Object)SERVER_ADDR);
            namingService = NacosConfiguration.getNacosNamingService(node);
            if (namingService.getServerStatus() == "UP") {
                SERVER_ADDR = node;
                log.info("The registry node switches to {}", (Object)SERVER_ADDR);
                return namingService.getAllInstances(serviceName);
            }
            log.warn("naocs server [{}] is unavalable", nodes);
        }
        return namingService.getAllInstances(serviceName);
    }

    public static List<Instance> getAllInstance(String serviceName, String groupName) throws NacosException, RpcException {
        if (nodes.length != 1 && namingService.getServerStatus() == "DOWN") {
            String node = loadBalancer.selectNode(nodes);
            log.info("disaster recovery switch occurred in registration center[{}]", (Object)SERVER_ADDR);
            namingService = NacosConfiguration.getNacosNamingService(node);
            if (namingService.getServerStatus() == "UP") {
                SERVER_ADDR = node;
                log.info("The registry node switches to {}", (Object)SERVER_ADDR);
                return namingService.getAllInstances(serviceName, groupName);
            }
            log.warn("naocs server [{}] is unavalable", nodes);
        }
        return namingService.getAllInstances(serviceName, groupName);
    }

    public static void registerService(String serviceName, InetSocketAddress address) throws NacosException {
        namingService.registerInstance(serviceName, address.getHostName(), address.getPort());
        log.info("host[{}], service[{}] has been registered on Register Center", (Object)address.getHostName(), (Object)serviceName);
        inetSocketAddress = address;
        serviceNames.add(serviceName);
    }

    public static void registerService(String serviceName, String groupName, InetSocketAddress address) throws NacosException {
        namingService.registerInstance(serviceName, groupName, address.getHostName(), address.getPort());
        log.info("host[{}], service[{}] has been registered on Register Center", (Object)address.getHostName(), (Object)serviceName);
        inetSocketAddress = address;
        serviceNames.add(serviceName);
    }

    public static void clearRegistry() {
        if (!serviceNames.isEmpty() && inetSocketAddress != null) {
            String hostname = inetSocketAddress.getHostName();
            int port = inetSocketAddress.getPort();
            for (String serviceName : serviceNames) {
                try {
                    serviceNames.remove(serviceName);
                    namingService.deregisterInstance(serviceName, hostname, port);
                }
                catch (NacosException e) {
                    log.error("Failed to cancel service:{}, info:{}", (Object)serviceName, (Object)e);
                }
            }
            log.info("All services on the nacos service have been cleaned up successfully");
        }
    }

    static {
        SERVER_ADDR = "127.0.0.1:8848";
        nodes = null;
        Properties p = new Properties();
        String currentWorkPath = System.getProperty("user.dir");
        Object is = null;
        ResourceBundle configResource = null;
        String useCluster = "";
        String balancer = "round";
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(currentWorkPath + "/config/resource.properties"));){
            configResource = new PropertyResourceBundle(bufferedReader);
            useCluster = configResource.getString("cn.fyupeng.nacos.cluster.use");
            if ("false".equals(useCluster) || "default".equals(useCluster) || StringUtils.isBlank(useCluster)) {
                log.info("begin start with single mode");
                nodes = new String[1];
                try {
                    NacosConfiguration.nodes[0] = configResource.getString("cn.fyupeng.nacos.register-addr");
                }
                catch (MissingResourceException registerAddException) {
                    NacosConfiguration.nodes[0] = SERVER_ADDR;
                    log.warn("nacos register address attribute is missing");
                    log.info("use default register address : " + SERVER_ADDR);
                }
            } else {
                if ("true".equals(useCluster)) {
                    log.info("cluster mode attribute is true and start with cluster mode");
                    try {
                        balancer = configResource.getString("cn.fyupeng.nacos.cluster.load-balancer");
                    }
                    catch (MissingResourceException loadBalancerException) {
                        log.info("nacos property attribute is missing: {}", (Object)loadBalancerException.getMessage());
                        log.info("use default loadBalancer : " + balancer);
                    }
                    try {
                        nodes = configResource.getString("cn.fyupeng.nacos.cluster.nodes").split("[;,|]");
                    }
                    catch (MissingResourceException clusterNodesException) {
                        log.error("nacos cluster nodes attribute is missing: ", clusterNodesException);
                        throw new RuntimeException("nacos cluster nodes attribute is missing!");
                    }
                }
                throw new RuntimeException("nacos cluster mode attribute is illegal!");
            }
            log.info("read resource from resource path: {}", (Object)(currentWorkPath + "/config/resource.properties"));
        }
        catch (MissingResourceException clusterUseException) {
            log.warn("nacos cluster use attribute is missing");
            log.info("begin start with default single mode");
            nodes = new String[1];
            try {
                String nacosRegisterAddr = configResource.getString("cn.fyupeng.nacos.register-addr");
                NacosConfiguration.nodes[0] = StringUtils.isBlank(nacosRegisterAddr) ? SERVER_ADDR : nacosRegisterAddr;
            }
            catch (MissingResourceException registerAddException) {
                NacosConfiguration.nodes[0] = SERVER_ADDR;
                log.warn("nacos register address attribute is missing");
                log.info("use default register address : " + SERVER_ADDR);
            }
        }
        catch (IOException ioException) {
            block56: {
                log.info("not found resource from resource path: {}", (Object)(currentWorkPath + "/config/resource.properties"));
                try {
                    ResourceBundle resource = ResourceBundle.getBundle("resource");
                    try {
                        useCluster = resource.getString("cn.fyupeng.nacos.cluster.use");
                        if ("false".equals(useCluster) || "default".equals(useCluster) || StringUtils.isBlank(useCluster)) {
                            log.info("begin start with default single mode");
                            nodes = new String[1];
                            try {
                                String nacosRegisterAddr = resource.getString("cn.fyupeng.nacos.register-addr");
                                NacosConfiguration.nodes[0] = StringUtils.isBlank(nacosRegisterAddr) ? SERVER_ADDR : nacosRegisterAddr;
                            }
                            catch (MissingResourceException registerAddException) {
                                NacosConfiguration.nodes[0] = SERVER_ADDR;
                                log.warn("nacos register address attribute is missing");
                                log.info("use default register address : " + SERVER_ADDR);
                            }
                            break block56;
                        }
                        if ("true".equals(useCluster)) {
                            log.info("cluster mode attribute is true and start with cluster mode");
                            try {
                                balancer = resource.getString("cn.fyupeng.nacos.cluster.load-balancer");
                            }
                            catch (MissingResourceException loadBalancerException) {
                                log.info("nacos property attribute is missing: {}", (Object)loadBalancerException.getMessage());
                                log.info("use default loadBalancer : " + balancer);
                            }
                            try {
                                nodes = resource.getString("cn.fyupeng.nacos.cluster.nodes").split("[;,|]");
                                break block56;
                            }
                            catch (MissingResourceException clusterNodesException) {
                                log.error("nacos cluster nodes attribute is missing: ", clusterNodesException);
                                throw new RuntimeException("nacos cluster nodes attribute is missing!");
                            }
                        }
                        throw new RuntimeException("nacos cluster mode attribute is illegal!");
                    }
                    catch (MissingResourceException clusterUseException) {
                        log.info("cluster mode attribute is missing and start with single mode");
                        nodes = new String[1];
                        NacosConfiguration.nodes[0] = resource.getString("cn.fyupeng.nacos.register-addr");
                    }
                }
                catch (MissingResourceException resourceException) {
                    log.info("not found resource from resource path: {}", (Object)"resource.properties");
                    log.info("Register center bind with default address {}", (Object)SERVER_ADDR);
                }
            }
            log.info("read resource from resource path: {}", (Object)"resource.properties");
        }
        int pre = -1;
        String host = "";
        Integer port = 0;
        String node = null;
        if ("random".equals(balancer)) {
            loadBalancer = LoadBalancer.getByCode(LoadBalancerCode.RANDOM.getCode());
            log.info("use { {} } loadBalancer", (Object)loadBalancer.getClass().getName());
        } else if ("round".equals(balancer)) {
            loadBalancer = LoadBalancer.getByCode(LoadBalancerCode.ROUNDROBIN.getCode());
            log.info("use { {} } loadBalancer", (Object)loadBalancer.getClass().getName());
        } else {
            log.error("naocs cluster loadBalancer attribute is illegal!");
            throw new RuntimeException("naocs cluster loadBalancer attribute is illegal!");
        }
        do {
            try {
                node = loadBalancer.selectNode(nodes);
                log.info("waiting for connection to the registration center...");
                pre = node.indexOf(":");
                if (pre > 0 && pre == node.lastIndexOf(":")) {
                    host = node.substring(0, pre);
                    boolean valid = IpUtils.valid(host);
                    if (valid) {
                        host = node.substring(0, pre);
                        port = Integer.parseInt(node.substring(pre + 1));
                        if (host.equals("localhost")) {
                            SERVER_ADDR = "127.0.0.1:" + port;
                            continue;
                        }
                        SERVER_ADDR = node;
                        continue;
                    }
                    log.error("wrong ip address: {}", (Object)node);
                    continue;
                }
                if (node.equals("")) continue;
                log.error("wrong ip address: {}", (Object)node);
            }
            catch (RpcException valid) {
                // empty catch block
            }
        } while ((namingService = NacosConfiguration.getNacosNamingService(null)).getServerStatus() == "DOWN");
        if (namingService.getServerStatus() == "UP") {
            log.info("Register center bind with address {}", (Object)node);
        } else if (nodes != null && nodes.length == 1) {
            log.error("SingleTon Register Center is down from {}", (Object)SERVER_ADDR);
        } else if (nodes != null && nodes.length != 1) {
            log.error("Cluster Register Center is down from ");
            log.error("---");
            for (int i = 0; i < nodes.length; ++i) {
                log.error("{}", (Object)nodes[i]);
            }
            log.error("---");
        } else {
            log.error("Service occupy Internal Errors");
        }
    }
}

