/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.hook;

import cn.fyupeng.idworker.utils.JRedisHelper;
import cn.fyupeng.net.RpcServer;
import cn.fyupeng.registry.ServiceRegistry;
import cn.fyupeng.util.IpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerShutdownHook {
    private static final Logger log = LoggerFactory.getLogger(ServerShutdownHook.class);
    private static final ServerShutdownHook shutdownHook = new ServerShutdownHook();
    private ServiceRegistry serviceRegistry;
    private RpcServer rpcServer;

    public ServerShutdownHook addRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        return this;
    }

    public ServerShutdownHook addServer(RpcServer rpcServer) {
        this.rpcServer = rpcServer;
        return this;
    }

    public static ServerShutdownHook getShutdownHook() {
        return shutdownHook;
    }

    public void addClearAllHook() {
        log.info("All services will be cancel after shutdown");
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            JRedisHelper.remWorkerId(IpUtils.getPubIpAddr());
            log.info("the cache for workId has bean cleared successfully");
            if (this.serviceRegistry != null) {
                this.serviceRegistry.clearRegistry();
            }
            if (this.rpcServer != null) {
                this.rpcServer.shutdown();
            }
        }));
    }
}

