/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.proxy;

import cn.fyupeng.annotation.Reference;
import cn.fyupeng.config.Configuration;
import cn.fyupeng.exception.AsyncTimeUnreasonableException;
import cn.fyupeng.exception.RetryTimeoutException;
import cn.fyupeng.exception.RpcTransmissionException;
import cn.fyupeng.factory.SingleFactory;
import cn.fyupeng.idworker.Sid;
import cn.fyupeng.net.RpcClient;
import cn.fyupeng.net.netty.client.NettyClient;
import cn.fyupeng.net.netty.client.UnprocessedRequests;
import cn.fyupeng.net.socket.client.SocketClient;
import cn.fyupeng.protocol.RpcRequest;
import cn.fyupeng.protocol.RpcResponse;
import cn.fyupeng.util.RpcMessageChecker;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcClientProxy
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(RpcClientProxy.class);
    private RpcClient rpcClient;
    private Class<?> pareClazz = null;
    private AtomicInteger sucRes = new AtomicInteger(0);
    private AtomicInteger errRes = new AtomicInteger(0);
    private AtomicInteger timeoutRes = new AtomicInteger(0);
    private static UnprocessedRequests unprocessedRequests = SingleFactory.getInstance(UnprocessedRequests.class);

    public RpcClientProxy(RpcClient rpcClient) {
        this.rpcClient = rpcClient;
    }

    public <T> T getProxy(Class<T> clazz, Class<?> pareClazz) {
        this.pareClazz = pareClazz;
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this);
    }

    @Deprecated
    public <T> T getProxy(Class<T> clazz) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Field[] fields;
        RpcRequest rpcRequest = new RpcRequest.Builder().requestId(Sid.next()).interfaceName(method.getDeclaringClass().getName()).methodName(method.getName()).parameters(args).paramTypes(method.getParameterTypes()).returnType(method.getReturnType()).heartBeat(false).build();
        RpcResponse rpcResponse = null;
        if (this.pareClazz == null) {
            log.info("invoke method:{}#{}", (Object)method.getDeclaringClass().getName(), (Object)method.getName());
            if (this.rpcClient instanceof NettyClient) {
                CompletableFuture completableFuture = (CompletableFuture)this.rpcClient.sendRequest(rpcRequest);
                rpcResponse = (RpcResponse)completableFuture.get();
            }
            if (this.rpcClient instanceof SocketClient) {
                rpcResponse = (RpcResponse)this.rpcClient.sendRequest(rpcRequest);
            }
            RpcMessageChecker.checkAndThrow(rpcRequest, rpcResponse);
            return rpcResponse.getData();
        }
        for (Field field : fields = this.pareClazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Reference.class) || !method.getDeclaringClass().getName().equals(field.getType().getName())) continue;
            String name = field.getAnnotation(Reference.class).name();
            String group = field.getAnnotation(Reference.class).group();
            if (!"".equals(name)) {
                rpcRequest.setInterfaceName(name);
            }
            if ("".equals(group)) break;
            rpcRequest.setGroup(group);
            break;
        }
        log.info("invoke method:{}#{}", (Object)method.getDeclaringClass().getName(), (Object)method.getName());
        if (this.rpcClient instanceof NettyClient) {
            long timeout = 0L;
            long asyncTime = 0L;
            int retries = 0;
            boolean useRetry = false;
            for (Field field : fields) {
                if (!field.isAnnotationPresent(Reference.class) || !method.getDeclaringClass().getName().equals(field.getType().getName())) continue;
                retries = field.getAnnotation(Reference.class).retries();
                timeout = field.getAnnotation(Reference.class).timeout();
                asyncTime = field.getAnnotation(Reference.class).asyncTime();
                useRetry = true;
                break;
            }
            if (!useRetry || asyncTime <= 0L) {
                log.debug("discover @Reference or asyncTime <= 0, will use blocking mode");
                long startTime = System.currentTimeMillis();
                CompletableFuture completableFuture = (CompletableFuture)this.rpcClient.sendRequest(rpcRequest);
                rpcResponse = (RpcResponse)completableFuture.get();
                long endTime = System.currentTimeMillis();
                log.info("handling the task takes time {} ms", (Object)(endTime - startTime));
                RpcMessageChecker.checkAndThrow(rpcRequest, rpcResponse);
            } else {
                log.debug("discover @Reference and asyncTime > 0, will use blocking mode");
                if (timeout >= asyncTime) {
                    log.error("asyncTime [ {} ] should be greater than timeout [ {} ]", (Object)asyncTime, (Object)timeout);
                    throw new AsyncTimeUnreasonableException("Asynchronous time is unreasonable, it should greater than timeout");
                }
                long handleTime = 0L;
                boolean checkPass = false;
                for (int i = 0; i < retries; ++i) {
                    long startTime = System.currentTimeMillis();
                    CompletableFuture completableFuture = (CompletableFuture)this.rpcClient.sendRequest(rpcRequest);
                    try {
                        rpcResponse = (RpcResponse)completableFuture.get(asyncTime, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException e) {
                        this.timeoutRes.incrementAndGet();
                        log.warn("recommend that asyncTime [ {} ] should be greater than current task runeTime [ {} ]", (Object)asyncTime, (Object)(System.currentTimeMillis() - startTime));
                        continue;
                    }
                    long endTime = System.currentTimeMillis();
                    handleTime = endTime - startTime;
                    log.info("handling the task takes time {} ms", (Object)handleTime);
                    if (handleTime >= timeout) {
                        log.warn("invoke service timeout and retry to invoke [ rms: {}, tms: {} ]", (Object)handleTime, (Object)timeout);
                        log.info("client  call timeout counts {}", (Object)this.timeoutRes.incrementAndGet());
                        continue;
                    }
                    checkPass = RpcMessageChecker.check(rpcRequest, rpcResponse);
                    if (!checkPass) continue;
                    log.info("client call success counts {} [ rms: {}, tms: {} ]", this.sucRes.incrementAndGet(), handleTime, timeout);
                    return rpcResponse.getData();
                }
                if (!checkPass) {
                    throw new RpcTransmissionException("RPC data transmission is abnormal, the packet is hijacked to trigger the retransmission mechanism, the retransmission mechanism is frequently hijacked under retry, and the operation is interrupted here");
                }
                log.info("client call failed counts {} [ rms: {}, tms: {} ]", this.errRes.incrementAndGet(), handleTime, timeout);
                unprocessedRequests.remove(rpcRequest.getRequestId());
                throw new RetryTimeoutException("The retry call timeout exceeds the threshold, the channel is closed, the thread is interrupted, and an exception is forced to be thrown!");
            }
        }
        if (this.rpcClient instanceof SocketClient) {
            rpcResponse = (RpcResponse)this.rpcClient.sendRequest(rpcRequest);
            RpcMessageChecker.checkAndThrow(rpcRequest, rpcResponse);
        }
        return rpcResponse.getData();
    }

    static {
        ServiceLoader.load(Configuration.class).iterator().next();
    }
}

