/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.registry;

import cn.fyupeng.config.NacosConfiguration;
import cn.fyupeng.exception.RegisterFailedException;
import cn.fyupeng.exception.RpcException;
import cn.fyupeng.registry.ServiceRegistry;
import com.alibaba.nacos.api.exception.NacosException;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosServiceRegistry
implements ServiceRegistry {
    private static final Logger log = LoggerFactory.getLogger(NacosServiceRegistry.class);

    @Override
    public void register(String serviceName, InetSocketAddress inetSocketAddress) throws RpcException {
        try {
            NacosConfiguration.registerService((String)serviceName, (InetSocketAddress)inetSocketAddress);
        }
        catch (NacosException e) {
            log.error("Failed to register service", (Object)e.getMessage());
            throw new RegisterFailedException("Failed to register service Exception");
        }
    }

    @Override
    public void register(String serviceName, String groupName, InetSocketAddress inetSocketAddress) throws RpcException {
        try {
            NacosConfiguration.registerService((String)serviceName, (String)groupName, (InetSocketAddress)inetSocketAddress);
        }
        catch (NacosException e) {
            log.error("Failed to register service", (Object)e.getMessage());
            throw new RegisterFailedException("Failed to register service Exception");
        }
    }

    @Override
    public void clearRegistry() {
        NacosConfiguration.clearRegistry();
    }
}

