/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.net.netty.server;

import cn.fyupeng.config.AbstractRedisConfiguration;
import cn.fyupeng.factory.ThreadPoolFactory;
import cn.fyupeng.handler.RequestHandler;
import cn.fyupeng.protocol.RpcRequest;
import cn.fyupeng.protocol.RpcResponse;
import cn.fyupeng.serializer.CommonSerializer;
import cn.fyupeng.util.JsonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ReferenceCountUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyChannelDispatcher {
    private static final Logger log;
    private static ExecutorService operationExecutorService;
    private static CommonSerializer serializer;
    private static RequestHandler requestHandler;
    private static String redisServerWay;
    private static String redisServerAsync;

    public static void init() {
        log.info("netty channel dispatcher initialize successfully!");
    }

    public static void dispatch(final ChannelHandlerContext ctx, final RpcRequest msg) {
        operationExecutorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    log.info("server has received request package: {}", (Object)msg);
                    Object result = null;
                    AbstractRedisConfiguration redisServerConfig = AbstractRedisConfiguration.getServerConfig();
                    if (!redisServerConfig.existsRetryResult(msg.getRequestId())) {
                        log.info("requestId[{}] does not exist, store the result in the distributed cache", (Object)msg.getRequestId());
                        result = requestHandler.handler(msg);
                        if (result != null) {
                            NettyChannelDispatcher.writeResultToChannel(ctx, msg, result);
                            String redisServerWay = AbstractRedisConfiguration.getRedisServerWay();
                            if ("jedis".equals(redisServerWay)) {
                                redisServerConfig.setRetryRequestResultByString(msg.getRequestId(), JsonUtils.objectToJson(result));
                            } else {
                                String redisServerAsync = AbstractRedisConfiguration.getRedisServerAsync();
                                if ("true".equals(redisServerAsync)) {
                                    redisServerConfig.asyncSetRetryRequestResult(msg.getRequestId(), serializer.serialize(result));
                                } else {
                                    redisServerConfig.setRetryRequestResultByBytes(msg.getRequestId(), serializer.serialize(result));
                                }
                            }
                        } else {
                            String redisServerAsync = AbstractRedisConfiguration.getRedisServerAsync();
                            if ("true".equals(redisServerAsync)) {
                                redisServerConfig.asyncSetRetryRequestResult(msg.getRequestId(), null);
                            } else {
                                redisServerConfig.setRetryRequestResultByBytes(msg.getRequestId(), null);
                            }
                        }
                    } else {
                        String redisServerWay = AbstractRedisConfiguration.getRedisServerWay();
                        if ("jedis".equals(redisServerWay)) {
                            result = redisServerConfig.getResultForRetryRequestId2String(msg.getRequestId());
                            if (result != null) {
                                result = JsonUtils.jsonToPojo((String)result, msg.getReturnType());
                            }
                        } else {
                            result = redisServerConfig.getResultForRetryRequestId2Bytes(msg.getRequestId());
                            if (result != null) {
                                result = serializer.deserialize((byte[])result, msg.getReturnType());
                            }
                        }
                        log.debug("Previous results:{} ", result);
                        log.info(" >>> Capture the timeout packet and call the previous result successfully <<< ");
                        log.info(" ===> requestId: {} [method: {}, returnType: {}]", msg.getRequestId(), msg.getMethodName(), msg.getReturnType());
                        NettyChannelDispatcher.writeResultToChannel(ctx, msg, result);
                    }
                }
                finally {
                    ReferenceCountUtil.release(msg);
                }
            }
        });
    }

    private static void writeResultToChannel(ChannelHandlerContext ctx, RpcRequest msg, Object result) {
        if (ctx.channel().isActive() && ctx.channel().isWritable()) {
            String checkCode = "";
            if (result != null) {
                try {
                    checkCode = new String(DigestUtils.md5(result.toString().getBytes("UTF-8")));
                }
                catch (UnsupportedEncodingException e) {
                    log.error("binary stream conversion failure: ", e);
                }
            } else {
                checkCode = null;
            }
            RpcResponse rpcResponse = RpcResponse.success(result, msg.getRequestId(), checkCode);
            log.info(String.format("server send back response package {requestId: %s, message: %s, statusCode: %s ]}", rpcResponse.getRequestId(), rpcResponse.getMessage(), rpcResponse.getStatusCode()));
            ChannelFuture channelFuture = ctx.writeAndFlush(rpcResponse);
        } else {
            log.info("channel status [active: {}, writable: {}]", (Object)ctx.channel().isActive(), (Object)ctx.channel().isWritable());
            log.error("channel is not writable");
        }
    }

    public static void shutdownAll() {
        ThreadPoolFactory.shutdownAll();
    }

    static {
        block29: {
            log = LoggerFactory.getLogger(NettyChannelDispatcher.class);
            operationExecutorService = ThreadPoolFactory.createDefaultThreadPool("operation-executor-pool");
            serializer = CommonSerializer.getByCode(CommonSerializer.HESSIAN_SERIALIZER);
            redisServerWay = "";
            redisServerAsync = "";
            String currentWorkPath = System.getProperty("user.dir");
            PropertyResourceBundle configResource = null;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(currentWorkPath + "/config/resource.properties"));){
                configResource = new PropertyResourceBundle(bufferedReader);
                redisServerWay = configResource.getString("cn.fyupeng.redis.server-way");
                if ("jedis".equals(redisServerWay) || "default".equals(redisServerWay) || StringUtils.isBlank(redisServerWay)) {
                    log.info("find redis client way attribute is jedis");
                    break block29;
                }
                if ("lettuce".equals(redisServerWay)) {
                    log.info("find redis client way attribute is lettuce");
                    try {
                        redisServerAsync = configResource.getString("cn.fyupeng.redis.server-async");
                        if ("false".equals(redisServerAsync) || "default".equals(redisServerAsync) || StringUtils.isBlank(redisServerAsync)) {
                            log.info("find redis server async attribute is false");
                            break block29;
                        }
                        if ("true".equals(redisServerAsync)) {
                            log.info("find redis server async attribute is lettuce");
                            break block29;
                        }
                        throw new RuntimeException("redis server async attribute is illegal!");
                    }
                    catch (MissingResourceException redisServerAsyncException) {
                        log.warn("redis server async attribute is missing");
                        log.info("use default redis server default async: false");
                        redisServerAsync = "false";
                    }
                    break block29;
                }
                throw new RuntimeException("redis server async attribute is illegal!");
            }
            catch (MissingResourceException redisServerWayException) {
                log.warn("redis client way attribute is missing");
                log.info("use default redis client default way: jedis");
                redisServerWay = "jedis";
            }
            catch (IOException ioException) {
                block30: {
                    log.info("not found resource from resource path: {}", (Object)(currentWorkPath + "/config/resource.properties"));
                    try {
                        ResourceBundle resource = ResourceBundle.getBundle("resource");
                        redisServerWay = resource.getString("cn.fyupeng.redis.server-way");
                        if ("jedis".equals(redisServerWay) || "default".equals(redisServerWay) || StringUtils.isBlank(redisServerWay)) {
                            log.info("find redis server way attribute is jedis");
                            break block30;
                        }
                        if ("lettuce".equals(redisServerWay)) {
                            log.info("find redis server way attribute is lettuce");
                            try {
                                redisServerAsync = resource.getString("cn.fyupeng.redis.server-async");
                                if ("false".equals(redisServerAsync) || "default".equals(redisServerAsync) || StringUtils.isBlank(redisServerAsync)) {
                                    log.info("find redis server async attribute is false");
                                    break block30;
                                }
                                if ("true".equals(redisServerAsync)) {
                                    log.info("find redis server async attribute is lettuce");
                                    break block30;
                                }
                                throw new RuntimeException("redis server async attribute is illegal!");
                            }
                            catch (MissingResourceException redisServerAsyncException) {
                                log.warn("redis server async attribute is missing");
                                log.info("use default redis server default async: false");
                                redisServerAsync = "false";
                            }
                            break block30;
                        }
                        throw new RuntimeException("redis client way attribute is illegal!");
                    }
                    catch (MissingResourceException resourceException) {
                        log.info("not found resource from resource path: {}", (Object)"resource.properties");
                        log.info("use default redis server way: jedis");
                        redisServerWay = "jedis";
                    }
                }
                log.info("read resource from resource path: {}", (Object)"resource.properties");
            }
        }
        requestHandler = new RequestHandler();
    }
}

