/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.proxy;

import cn.fyupeng.annotation.Reference;
import cn.fyupeng.config.AbstractRedisConfiguration;
import cn.fyupeng.config.Configuration;
import cn.fyupeng.exception.AsyncTimeUnreasonableException;
import cn.fyupeng.exception.RetryTimeoutException;
import cn.fyupeng.exception.RpcTransmissionException;
import cn.fyupeng.factory.SingleFactory;
import cn.fyupeng.hook.ClientShutdownHook;
import cn.fyupeng.idworker.Sid;
import cn.fyupeng.idworker.WorkerIdServer;
import cn.fyupeng.net.RpcClient;
import cn.fyupeng.net.netty.client.NettyClient;
import cn.fyupeng.net.netty.client.UnprocessedRequests;
import cn.fyupeng.net.socket.client.SocketClient;
import cn.fyupeng.protocol.RpcRequest;
import cn.fyupeng.protocol.RpcResponse;
import cn.fyupeng.util.RpcMessageChecker;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcClientProxy
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(RpcClientProxy.class);
    private RpcClient rpcClient;
    private Class<?> pareClazz = null;
    private static UnprocessedRequests unprocessedRequests = SingleFactory.getInstance(UnprocessedRequests.class);
    private static String redisServerWay = "";

    public RpcClientProxy(RpcClient rpcClient) {
        this.rpcClient = rpcClient;
        ClientShutdownHook.getShutdownHook().addClient(rpcClient).addClearAllHook();
    }

    public <T> T getProxy(Class<T> clazz, Class<?> pareClazz) {
        this.pareClazz = pareClazz;
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this);
    }

    @Deprecated
    public <T> T getProxy(Class<T> clazz) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        log.info("begin new RpcResponse");
        RpcRequest rpcRequest = new RpcRequest.Builder().requestId(Sid.next()).interfaceName(method.getDeclaringClass().getName()).methodName(method.getName()).parameters(args).paramTypes(method.getParameterTypes()).returnType(method.getReturnType()).heartBeat(false).build();
        log.info("end new RpcResponse");
        RpcResponse rpcResponse = null;
        if (this.rpcClient instanceof SocketClient) {
            rpcResponse = this.revokeSocketClient(rpcRequest, method);
        } else if (this.rpcClient instanceof NettyClient) {
            rpcResponse = this.revokeNettyClient(rpcRequest, method);
        }
        return rpcResponse == null ? null : rpcResponse.getData();
    }

    private RpcResponse revokeNettyClient(RpcRequest rpcRequest, Method method) throws Throwable {
        Field[] fields;
        log.info("begin scan annotation");
        RpcResponse rpcResponse = null;
        if (this.pareClazz == null) {
            CompletableFuture completableFuture = (CompletableFuture)this.rpcClient.sendRequest(rpcRequest);
            rpcResponse = (RpcResponse)completableFuture.get();
            RpcMessageChecker.checkAndThrow(rpcRequest, rpcResponse);
            return rpcResponse;
        }
        for (Field field : fields = this.pareClazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Reference.class) || !method.getDeclaringClass().getName().equals(field.getType().getName())) continue;
            String name = field.getAnnotation(Reference.class).name();
            String group = field.getAnnotation(Reference.class).group();
            if (!"".equals(name)) {
                rpcRequest.setInterfaceName(name);
            }
            if ("".equals(group)) break;
            rpcRequest.setGroup(group);
            break;
        }
        long timeout = 0L;
        long asyncTime = 0L;
        int retries = 0;
        boolean useRetry = false;
        for (Field field : fields) {
            if (!field.isAnnotationPresent(Reference.class) || !method.getDeclaringClass().getName().equals(field.getType().getName())) continue;
            retries = field.getAnnotation(Reference.class).retries();
            timeout = field.getAnnotation(Reference.class).timeout();
            asyncTime = field.getAnnotation(Reference.class).asyncTime();
            useRetry = true;
            break;
        }
        log.info("end scan annotation");
        if (useRetry && asyncTime > 0L) {
            log.debug("discover @Reference and asyncTime > 0, will use blocking mode");
            if (timeout >= asyncTime) {
                log.error("asyncTime [ {} ] should be greater than timeout [ {} ]", (Object)asyncTime, (Object)timeout);
                throw new AsyncTimeUnreasonableException("Asynchronous time is unreasonable, it should greater than timeout");
            }
            long handleTime = 0L;
            boolean checkPass = false;
            for (int i = 0; i < retries; ++i) {
                long startTime = System.currentTimeMillis();
                log.info("start calling remote service [requestId: {}, serviceMethod: {}]", (Object)rpcRequest.getRequestId(), (Object)rpcRequest.getMethodName());
                CompletableFuture completableFuture = (CompletableFuture)this.rpcClient.sendRequest(rpcRequest);
                try {
                    rpcResponse = (RpcResponse)completableFuture.get(asyncTime, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    log.warn("recommend that asyncTime [ {} ] should be greater than current task runeTime [ {} ]", (Object)asyncTime, (Object)(System.currentTimeMillis() - startTime));
                    continue;
                }
                long endTime = System.currentTimeMillis();
                handleTime = endTime - startTime;
                if (handleTime >= timeout) {
                    log.warn("call service timeout and retry to call [ rms: {}, tms: {} ]", (Object)handleTime, (Object)timeout);
                    continue;
                }
                checkPass = RpcMessageChecker.check(rpcRequest, rpcResponse);
                if (!checkPass) continue;
                log.info("client call success [ rms: {}, tms: {} ]", (Object)handleTime, (Object)timeout);
                return rpcResponse;
            }
            if (!checkPass) {
                throw new RpcTransmissionException("RPC data transmission is abnormal, the packet is hijacked to trigger the retransmission mechanism, the retransmission mechanism is frequently hijacked under retry, and the operation is interrupted here");
            }
            log.info("client call failed  [ rms: {}, tms: {} ]", (Object)handleTime, (Object)timeout);
            unprocessedRequests.remove(rpcRequest.getRequestId());
            throw new RetryTimeoutException("The retry call timeout exceeds the threshold, the channel is closed, the thread is interrupted, and an exception is forced to be thrown!");
        }
        log.debug("discover @Reference or asyncTime <= 0, will use blocking mode");
        long startTime = System.currentTimeMillis();
        log.info("start calling remote service [requestId: {}, serviceMethod: {}]", (Object)rpcRequest.getRequestId(), (Object)rpcRequest.getMethodName());
        CompletableFuture completableFuture = (CompletableFuture)this.rpcClient.sendRequest(rpcRequest);
        rpcResponse = (RpcResponse)completableFuture.get();
        long endTime = System.currentTimeMillis();
        log.info("handling the task takes time {} ms", (Object)(endTime - startTime));
        RpcMessageChecker.checkAndThrow(rpcRequest, rpcResponse);
        return rpcResponse;
    }

    private RpcResponse revokeSocketClient(RpcRequest rpcRequest, Method method) throws Throwable {
        RpcResponse rpcResponse = null;
        if (this.pareClazz != null) {
            Field[] fields;
            for (Field field : fields = this.pareClazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Reference.class) || !method.getDeclaringClass().getName().equals(field.getType().getName())) continue;
                String name = field.getAnnotation(Reference.class).name();
                String group = field.getAnnotation(Reference.class).group();
                if (!"".equals(name)) {
                    rpcRequest.setInterfaceName(name);
                }
                if ("".equals(group)) break;
                rpcRequest.setGroup(group);
                break;
            }
        }
        rpcResponse = (RpcResponse)this.rpcClient.sendRequest(rpcRequest);
        RpcMessageChecker.checkAndThrow(rpcRequest, rpcResponse);
        return rpcResponse;
    }

    private static void configWorkerServer() {
        WorkerIdServer.preLoad();
    }

    static {
        AbstractRedisConfiguration.getClientConfig();
        RpcClientProxy.configWorkerServer();
        ServiceLoader.load(Configuration.class).iterator().next();
    }
}

