/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.proxy.factory.javassist;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;

public class ProxyGenerator {
    private static final AtomicInteger counter = new AtomicInteger(1);
    private static final int MAX_CACHE_SIZE = 1024;
    private static final Map<Class<?>, Object> proxyInstanceCache = new LinkedHashMap<Class<?>, Object>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 1024;
        }
    };

    public static Object newProxyInstance(ClassLoader classLoader, Class<?> targetInterface, InvocationHandler invocationHandler) throws Exception {
        Object proxyInstance = proxyInstanceCache.get(targetInterface);
        if (proxyInstance != null) {
            return proxyInstance;
        }
        ClassPool pool = ClassPool.getDefault();
        String qualifiedName = ProxyGenerator.generateClassName(targetInterface);
        CtClass proxy = pool.makeClass(qualifiedName);
        CtField mf = CtField.make("public static java.lang.reflect.Method[] methods;", proxy);
        proxy.addField(mf);
        CtField hf = CtField.make("private " + InvocationHandler.class.getName() + " handler;", proxy);
        proxy.addField(hf);
        CtConstructor constructor = new CtConstructor(new CtClass[]{pool.get(InvocationHandler.class.getName())}, proxy);
        constructor.setBody("this.handler=$1;");
        constructor.setModifiers(1);
        proxy.addConstructor(constructor);
        proxy.addConstructor(CtNewConstructor.defaultConstructor(proxy));
        CtClass ctClass = pool.get(targetInterface.getName());
        proxy.addInterface(ctClass);
        List<Method> publicMethods = ProxyGenerator.getPublicMethods(targetInterface);
        Method[] methods = publicMethods.toArray(new Method[0]);
        StringBuilder code = new StringBuilder();
        for (int i = 0; i < methods.length; ++i) {
            int j;
            Method method = methods[i];
            Class<?> returnType = method.getReturnType();
            Class<?>[] parameterTypes = method.getParameterTypes();
            Class<?>[] exceptionTypes = method.getExceptionTypes();
            int idx = i;
            code.append("Object[] args = new Object[").append(parameterTypes.length).append("];");
            for (int j2 = 0; j2 < parameterTypes.length; ++j2) {
                code.append(" args[").append(j2).append("] = ($w)$").append(j2 + 1).append(";");
            }
            code.append(" Object ret = handler.invoke(this, methods[" + idx + "], args);");
            if (!Void.TYPE.equals(returnType)) {
                code.append(" return ").append(ProxyGenerator.asArgument(returnType, "ret")).append(";");
            }
            StringBuilder sb = new StringBuilder(ProxyGenerator.modifier(method.getModifiers()));
            sb.append(' ').append(ProxyGenerator.getParameterType(returnType)).append(' ').append(method.getName());
            sb.append('(');
            for (j = 0; j < parameterTypes.length; ++j) {
                if (j > 0) {
                    sb.append(',');
                }
                sb.append(ProxyGenerator.getParameterType(parameterTypes[j]));
                sb.append(" arg").append(j);
            }
            sb.append(')');
            if (exceptionTypes.length > 0) {
                sb.append(" throws ");
                for (j = 0; j < exceptionTypes.length; ++j) {
                    if (j > 0) {
                        sb.append(',');
                    }
                    sb.append(ProxyGenerator.getParameterType(exceptionTypes[j]));
                }
            }
            sb.append('{').append(code.toString()).append('}');
            code.setLength(0);
            CtMethod ctMethod = CtMethod.make(sb.toString(), proxy);
            proxy.addMethod(ctMethod);
        }
        proxy.setModifiers(1);
        Class<?> proxyClass = proxy.toClass(classLoader, null);
        proxyClass.getField("methods").set(null, methods);
        proxyInstance = proxyClass.getConstructor(InvocationHandler.class).newInstance(invocationHandler);
        Object old = proxyInstanceCache.putIfAbsent(targetInterface, proxyInstance);
        if (old != null) {
            proxyInstance = old;
        }
        return proxyInstance;
    }

    private static String modifier(int mod) {
        if (Modifier.isPublic(mod)) {
            return "public";
        }
        if (Modifier.isProtected(mod)) {
            return "protected";
        }
        if (Modifier.isPrivate(mod)) {
            return "private";
        }
        return "";
    }

    private static String getParameterType(Class<?> c) {
        if (c.isArray()) {
            StringBuilder sb = new StringBuilder();
            do {
                sb.append("[]");
            } while ((c = c.getComponentType()).isArray());
            return c.getName() + sb.toString();
        }
        return c.getName();
    }

    private static String asArgument(Class<?> cl, String name) {
        if (cl.isPrimitive()) {
            if (Boolean.TYPE == cl) {
                return name + "==null?false:((Boolean)" + name + ").booleanValue()";
            }
            if (Byte.TYPE == cl) {
                return name + "==null?(byte)0:((Byte)" + name + ").byteValue()";
            }
            if (Character.TYPE == cl) {
                return name + "==null?(char)0:((Character)" + name + ").charValue()";
            }
            if (Double.TYPE == cl) {
                return name + "==null?(double)0:((Double)" + name + ").doubleValue()";
            }
            if (Float.TYPE == cl) {
                return name + "==null?(float)0:((Float)" + name + ").floatValue()";
            }
            if (Integer.TYPE == cl) {
                return name + "==null?(int)0:((Integer)" + name + ").intValue()";
            }
            if (Long.TYPE == cl) {
                return name + "==null?(long)0:((Long)" + name + ").longValue()";
            }
            if (Short.TYPE == cl) {
                return name + "==null?(short)0:((Short)" + name + ").shortValue()";
            }
            throw new RuntimeException(name + " is unknown primitive type.");
        }
        return "(" + ProxyGenerator.getParameterType(cl) + ")" + name;
    }

    private static String generateClassName(Class<?> type) {
        return String.format("%s$Proxy%d", type.getName(), counter.getAndIncrement());
    }

    private static List<Method> getPublicMethods(Class<?> targetInterfaces) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : targetInterfaces.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers())) continue;
            methods.add(method);
        }
        return methods;
    }
}

