/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http;

import com.alibaba.nacos.common.http.HttpClientConfig;
import com.alibaba.nacos.common.http.HttpClientFactory;
import com.alibaba.nacos.common.http.client.NacosAsyncRestTemplate;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.http.client.request.DefaultAsyncHttpClientRequest;
import com.alibaba.nacos.common.http.client.request.JdkHttpClientRequest;
import com.alibaba.nacos.common.tls.SelfHostnameVerifier;
import com.alibaba.nacos.common.tls.TlsFileWatcher;
import com.alibaba.nacos.common.tls.TlsHelper;
import com.alibaba.nacos.common.tls.TlsSystemConfig;
import com.alibaba.nacos.common.utils.BiConsumer;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.protocol.RequestContent;
import org.slf4j.Logger;

public abstract class AbstractHttpClientFactory
implements HttpClientFactory {
    @Override
    public NacosRestTemplate createNacosRestTemplate() {
        HttpClientConfig httpClientConfig = this.buildHttpClientConfig();
        final JdkHttpClientRequest clientRequest = new JdkHttpClientRequest(httpClientConfig);
        this.initTls(new BiConsumer<SSLContext, HostnameVerifier>(){

            @Override
            public void accept(SSLContext sslContext, HostnameVerifier hostnameVerifier) {
                clientRequest.setSSLContext(AbstractHttpClientFactory.this.loadSSLContext());
                clientRequest.replaceSSLHostnameVerifier(hostnameVerifier);
            }
        }, new TlsFileWatcher.FileChangeListener(){

            @Override
            public void onChanged(String filePath) {
                clientRequest.setSSLContext(AbstractHttpClientFactory.this.loadSSLContext());
            }
        });
        return new NacosRestTemplate(this.assignLogger(), clientRequest);
    }

    @Override
    public NacosAsyncRestTemplate createNacosAsyncRestTemplate() {
        HttpClientConfig originalRequestConfig = this.buildHttpClientConfig();
        return new NacosAsyncRestTemplate(this.assignLogger(), new DefaultAsyncHttpClientRequest(HttpAsyncClients.custom().addInterceptorLast(new RequestContent(true)).setDefaultIOReactorConfig(this.getIoReactorConfig()).setDefaultRequestConfig(this.getRequestConfig()).setMaxConnTotal(originalRequestConfig.getMaxConnTotal()).setMaxConnPerRoute(originalRequestConfig.getMaxConnPerRoute()).setUserAgent(originalRequestConfig.getUserAgent()).build()));
    }

    protected IOReactorConfig getIoReactorConfig() {
        HttpClientConfig httpClientConfig = this.buildHttpClientConfig();
        return IOReactorConfig.custom().setIoThreadCount(httpClientConfig.getIoThreadCount()).build();
    }

    protected RequestConfig getRequestConfig() {
        HttpClientConfig httpClientConfig = this.buildHttpClientConfig();
        return RequestConfig.custom().setConnectTimeout(httpClientConfig.getConTimeOutMillis()).setSocketTimeout(httpClientConfig.getReadTimeOutMillis()).setConnectionRequestTimeout(httpClientConfig.getConnectionRequestTimeout()).setContentCompressionEnabled(httpClientConfig.getContentCompressionEnabled()).setMaxRedirects(httpClientConfig.getMaxRedirects()).build();
    }

    protected void initTls(BiConsumer<SSLContext, HostnameVerifier> initTlsBiFunc, TlsFileWatcher.FileChangeListener tlsChangeListener) {
        if (!TlsSystemConfig.tlsEnable) {
            return;
        }
        HostnameVerifier hv = HttpsURLConnection.getDefaultHostnameVerifier();
        SelfHostnameVerifier selfHostnameVerifier = new SelfHostnameVerifier(hv);
        initTlsBiFunc.accept(this.loadSSLContext(), selfHostnameVerifier);
        if (tlsChangeListener != null) {
            try {
                TlsFileWatcher.getInstance().addFileChangeListener(tlsChangeListener, TlsSystemConfig.tlsClientTrustCertPath, TlsSystemConfig.tlsClientKeyPath);
            }
            catch (IOException e) {
                this.assignLogger().error("add tls file listener fail", e);
            }
        }
    }

    protected synchronized SSLContext loadSSLContext() {
        if (!TlsSystemConfig.tlsEnable) {
            return null;
        }
        try {
            return TlsHelper.buildSslContext(true);
        }
        catch (NoSuchAlgorithmException e) {
            this.assignLogger().error("Failed to create SSLContext", e);
        }
        catch (KeyManagementException e) {
            this.assignLogger().error("Failed to create SSLContext", e);
        }
        return null;
    }

    protected abstract HttpClientConfig buildHttpClientConfig();

    protected abstract Logger assignLogger();
}

