/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.net.netty.server;

import cn.fyupeng.codec.CommonDecoder;
import cn.fyupeng.codec.CommonEncoder;
import cn.fyupeng.config.AbstractRedisConfiguration;
import cn.fyupeng.exception.RpcException;
import cn.fyupeng.hook.ServerShutdownHook;
import cn.fyupeng.net.AbstractRpcServer;
import cn.fyupeng.net.netty.server.NettyChannelDispatcher;
import cn.fyupeng.net.netty.server.NettyServerHandler;
import cn.fyupeng.provider.ServiceProvider;
import cn.fyupeng.registry.ServiceRegistry;
import cn.fyupeng.serializer.CommonSerializer;
import cn.fyupeng.util.IpUtils;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServer
extends AbstractRpcServer {
    private static final Logger log = LoggerFactory.getLogger(NettyServer.class);
    private final CommonSerializer serializer;
    private static final EventLoopGroup bossGroup = new NioEventLoopGroup();
    private static final EventLoopGroup workerGroup = new NioEventLoopGroup();
    private static String redisServerWay = "";

    public NettyServer(String hostName, int port, Integer serializerCode) throws RpcException {
        this.hostName = hostName.equals("localhost") || hostName.equals("127.0.0.1") ? IpUtils.getPubIpAddr() : hostName;
        log.info("start with host: {}, port: {}", (Object)this.hostName, (Object)port);
        this.port = port;
        this.serviceRegistry = ServiceLoader.load(ServiceRegistry.class).iterator().next();
        this.serviceProvider = ServiceLoader.load(ServiceProvider.class).iterator().next();
        this.serializer = CommonSerializer.getByCode((int)serializerCode);
        this.scanServices();
    }

    @Override
    public void start() {
        ServerShutdownHook.getShutdownHook().addServer(this).addRegistry(this.serviceRegistry).addClearAllHook();
        try {
            ServerBootstrap serverBootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)serverBootstrap.group(bossGroup, workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).option(ChannelOption.SO_BACKLOG, (Object)256)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(30L, 0L, 0L, TimeUnit.SECONDS)});
                    pipeline.addLast(new ChannelHandler[]{new CommonEncoder(NettyServer.this.serializer)});
                    pipeline.addLast(new ChannelHandler[]{new CommonDecoder()});
                    pipeline.addLast(new ChannelHandler[]{new NettyServerHandler()});
                }
            });
            ChannelFuture future = serverBootstrap.bind(this.port).sync();
            future.channel().closeFuture().sync();
        }
        catch (Exception e) {
            log.error("Error occurred while starting server! {}", (Throwable)e);
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }

    @Override
    public void shutdown() {
        NettyServer.shutdownAll();
        NettyServer.shutdownNettyChannelDispatcher();
    }

    public static void shutdownNettyChannelDispatcher() {
        NettyChannelDispatcher.shutdownAll();
    }

    public static void shutdownAll() {
        log.info("close all EventLoopGroup now ...");
        try {
            bossGroup.shutdownGracefully().sync();
            log.info("close Netty Server Boss EventLoopGroup [{}] [{}]", bossGroup.getClass(), (Object)bossGroup.isTerminated());
        }
        catch (InterruptedException e) {
            log.error("close thread was interrupted: ", (Throwable)e);
        }
        try {
            workerGroup.shutdownGracefully().sync();
            log.info("close Netty Server Worker EventLoopGroup [{}] [{}]", workerGroup.getClass(), (Object)bossGroup.isTerminated());
        }
        catch (InterruptedException e) {
            log.error("close thread was interrupted: ", (Throwable)e);
        }
        try {
            bossGroup.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error("failed to close Netty Server Boss EventLoopGroup: ", (Throwable)e);
            bossGroup.shutdownNow();
        }
        try {
            workerGroup.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error("failed to close Netty Server Boss EventLoopGroup: ", (Throwable)e);
            workerGroup.shutdownNow();
        }
        log.info("Netty Server EventLoopGroup closed successfully");
    }

    static {
        AbstractRedisConfiguration.getServerConfig();
        NettyChannelDispatcher.init();
    }
}

