/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.net.netty.client;

import cn.fyupeng.discovery.ServiceDiscovery;
import cn.fyupeng.exception.RpcException;
import cn.fyupeng.factory.SingleFactory;
import cn.fyupeng.loadbalancer.LoadBalancer;
import cn.fyupeng.net.RpcClient;
import cn.fyupeng.net.netty.client.NettyChannelProvider;
import cn.fyupeng.net.netty.client.UnprocessedResults;
import cn.fyupeng.protocol.RpcRequest;
import cn.fyupeng.protocol.RpcResponse;
import cn.fyupeng.serializer.CommonSerializer;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.InetSocketAddress;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyClient
implements RpcClient {
    private static final Logger log = LoggerFactory.getLogger(NettyClient.class);
    private final CommonSerializer serializer;
    private static final EventLoopGroup group;
    private static final Bootstrap bootstrap;
    private String hostName;
    private int port;
    private ServiceDiscovery serviceDiscovery;
    private static final UnprocessedResults unprocessedRequests;

    public NettyClient(String hostName, int port, Integer serializerCode) {
        this.hostName = hostName;
        this.port = port;
        this.serializer = CommonSerializer.getByCode(serializerCode);
    }

    public NettyClient(LoadBalancer loadBalancer, Integer serializerCode) {
        this.serviceDiscovery = ServiceLoader.load(ServiceDiscovery.class).iterator().next();
        this.serviceDiscovery.setLoadBalancer(loadBalancer);
        this.serializer = CommonSerializer.getByCode(serializerCode);
    }

    @Override
    public CompletableFuture<RpcResponse> sendRequest(final RpcRequest rpcRequest) throws RpcException {
        Channel channel;
        final CompletableFuture<RpcResponse> resultFuture = new CompletableFuture<RpcResponse>();
        if (this.serviceDiscovery != null) {
            String serviceName = rpcRequest.getInterfaceName();
            InetSocketAddress address = null;
            String group = rpcRequest.getGroup();
            address = group != null ? this.serviceDiscovery.lookupService(serviceName, group) : this.serviceDiscovery.lookupService(serviceName);
            this.hostName = address.getHostName();
            this.port = address.getPort();
        }
        if (!(channel = NettyChannelProvider.get(new InetSocketAddress(this.hostName, this.port), this.serializer)).isActive()) {
            group.shutdownGracefully();
            return null;
        }
        unprocessedRequests.put(rpcRequest.getRequestId(), resultFuture);
        channel.writeAndFlush(rpcRequest).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    log.debug(String.format("customer completes sending message: %s", rpcRequest.toString()));
                } else {
                    future.channel().close();
                    resultFuture.completeExceptionally(future.cause());
                    log.error("Error occurred while sending message: ", future.cause());
                }
            }
        });
        return resultFuture;
    }

    @Override
    public void shutdown() {
        NettyChannelProvider.shutdownAll();
    }

    static {
        unprocessedRequests = SingleFactory.getInstance(UnprocessedResults.class);
        group = new NioEventLoopGroup();
        bootstrap = new Bootstrap();
        ((Bootstrap)bootstrap.group(group)).channel(NioSocketChannel.class);
    }
}

