/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.util;

import cn.fyupeng.enums.PackageType;
import cn.fyupeng.exception.UnrecognizedException;
import cn.fyupeng.protocol.RpcRequest;
import cn.fyupeng.protocol.RpcResponse;
import cn.fyupeng.serializer.CommonSerializer;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectReader {
    private static final Logger log = LoggerFactory.getLogger(ObjectReader.class);
    private static final int MAGIC_NUMBER = -889275714;

    public static Object readObject(InputStream in) throws IOException, UnrecognizedException {
        Class<RpcRequest> packageClass;
        byte[] numberBytes = new byte[4];
        in.read(numberBytes);
        int magic = ObjectReader.bytes2Int(numberBytes);
        if (magic != -889275714) {
            log.error("Unrecognized protocol package: {}", (Object)magic);
            throw new UnrecognizedException("Unrecognized protocol package error");
        }
        in.read(numberBytes);
        int packageCode = ObjectReader.bytes2Int(numberBytes);
        if (packageCode == PackageType.REQUEST_PACK.getCode()) {
            packageClass = RpcRequest.class;
        } else if (packageCode == PackageType.RESPONSE_PACK.getCode()) {
            packageClass = RpcResponse.class;
        } else {
            log.error("Unrecognized data package: {}", (Object)packageCode);
            throw new UnrecognizedException("Unrecognized data package error");
        }
        in.read(numberBytes);
        int serializerCode = ObjectReader.bytes2Int(numberBytes);
        CommonSerializer serializer = CommonSerializer.getByCode((int)serializerCode);
        if (serializer == null) {
            log.error("Unrecognized deserializer : {}", (Object)serializerCode);
            throw new UnrecognizedException("Unrecognized deserializer error");
        }
        in.read(numberBytes);
        int length = ObjectReader.bytes2Int(numberBytes);
        byte[] bytes = new byte[length];
        in.read(bytes, 0, length);
        return serializer.deserialize(bytes, packageClass);
    }

    private static int bytes2Int(byte[] value) {
        int result = 0;
        int mark = 255;
        if (value.length == 4) {
            int a = (value[0] & mark) << 24;
            int b = (value[1] & mark) << 16;
            int c = (value[2] & mark) << 8;
            int d = value[3] & mark;
            result = a | b | c | d;
        } else {
            log.error("Illegal size in bytes");
        }
        return result;
    }
}

